/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init.registrate;

import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.repack.registrate.builders.ItemBuilder;
import dev.xkmc.l2library.repack.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullFunction;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.twilightdelight.content.item.tool.FieryKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.IronwoodKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.KnightmetalKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.SteeleafKnifeItem;
import dev.xkmc.twilightdelight.content.item.tool.TeardropSwordItem;
import dev.xkmc.twilightdelight.init.TwilightDelight;
import dev.xkmc.twilightdelight.init.registrate.delight.EffectSupplier;
import dev.xkmc.twilightdelight.init.registrate.delight.IFoodType;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.loaders.ItemLayersModelBuilder;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.StringUtils;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class TDItems {
    public static final ItemEntry<FieryKnifeItem> FIERY_KNIFE;
    public static final ItemEntry<IronwoodKnifeItem> IRONWOOD_KNIFE;
    public static final ItemEntry<SteeleafKnifeItem> STEELEAF_KNIFE;
    public static final ItemEntry<KnightmetalKnifeItem> KNIGHTMETAL_KNIFE;
    public static final ItemEntry<TeardropSwordItem> TEARDROP_SWORD;
    private static final Set<String> SMALL_WORDS;

    public static ItemEntry<Item> simpleFood(IFoodType r, String name, int nutrition, float saturation, EffectSupplier ... effects) {
        return TDItems.food(name.toLowerCase(Locale.ROOT), p -> r.create(p.m_41497_(r.getRarity())), () -> TDItems.simpleFood(r, nutrition, saturation, effects)).model(r::model).register();
    }

    public static FoodProperties simpleFood(IFoodType r, int nutrition, float saturation, EffectSupplier ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder = builder.m_38760_(nutrition).m_38758_(saturation);
        builder = r.process(builder);
        for (EffectSupplier eff : effects) {
            builder = builder.effect(eff::get, eff.chance());
        }
        return builder.m_38767_();
    }

    private static <T extends Item> ItemBuilder<T, L2Registrate> food(String id, Function<Item.Properties, T> factory, Supplier<FoodProperties> food) {
        return TwilightDelight.REGISTRATE.item(id, p -> (Item)factory.apply(p.m_41489_((FoodProperties)food.get()))).lang(TDItems.toEnglishName(id));
    }

    public static String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(e -> SMALL_WORDS.contains(e) ? e : StringUtils.capitalize((String)e)).collect(Collectors.joining(" "));
    }

    private static <T extends Item> ItemBuilder<T, L2Registrate> handheld(String id, NonNullFunction<Item.Properties, T> factory) {
        return TwilightDelight.REGISTRATE.item(id, factory).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx));
    }

    public static void register() {
    }

    static {
        IRONWOOD_KNIFE = TDItems.handheld("ironwood_knife", IronwoodKnifeItem::new).tag(new TagKey[]{ModTags.KNIVES, ForgeTags.TOOLS_KNIVES}).register();
        STEELEAF_KNIFE = TDItems.handheld("steeleaf_knife", SteeleafKnifeItem::new).tag(new TagKey[]{ModTags.KNIVES, ForgeTags.TOOLS_KNIVES}).register();
        KNIGHTMETAL_KNIFE = TDItems.handheld("knightmetal_knife", KnightmetalKnifeItem::new).lang("Knightly Knife").tag(new TagKey[]{ModTags.KNIVES, ForgeTags.TOOLS_KNIVES}).register();
        FIERY_KNIFE = TDItems.handheld("fiery_knife", FieryKnifeItem::new).model((ctx, pvd) -> ((ItemLayersModelBuilder)pvd.handheld((NonNullSupplier)ctx).customLoader(ItemLayersModelBuilder::begin)).emissive(new int[]{0})).tag(new TagKey[]{ModTags.KNIVES, ForgeTags.TOOLS_KNIVES}).register();
        TEARDROP_SWORD = TDItems.handheld("teardrop_sword", TeardropSwordItem::new).model((ctx, pvd) -> ((ItemLayersModelBuilder)pvd.handheld((NonNullSupplier)ctx).customLoader(ItemLayersModelBuilder::begin)).emissive(new int[]{0})).tag(new TagKey[]{Tags.Items.TOOLS_SWORDS}).register();
        SMALL_WORDS = Set.of("of", "the", "with");
    }
}

