/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.compat.jeed;

import dev.xkmc.l2library.repack.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.twilightdelight.compat.jeed.JeedEffectRecipeBuilded;
import dev.xkmc.twilightdelight.compat.jeed.JeedEffectRecipeData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class JeedDataGenerator {
    private static JeedDataGenerator INSTANCE;
    private final LinkedHashMap<MobEffect, List<Item>> map = new LinkedHashMap();

    public static void add(Item item, MobEffect ... effects) {
        if (INSTANCE == null) {
            INSTANCE = new JeedDataGenerator();
        }
        for (MobEffect eff : effects) {
            INSTANCE.put(eff, item);
        }
    }

    public static void finalizeRecipes(RegistrateRecipeProvider pvd) {
        if (INSTANCE != null) {
            INSTANCE.generate(pvd);
        }
        INSTANCE = null;
    }

    private void put(MobEffect eff, Item item) {
        this.map.computeIfAbsent(eff, k -> new ArrayList()).add(item);
    }

    private void generate(RegistrateRecipeProvider pvd) {
        this.map.forEach((k, v) -> {
            JeedEffectRecipeData data = new JeedEffectRecipeData((MobEffect)k, new ArrayList<Ingredient>(v.stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).toList()));
            JeedEffectRecipeBuilded recipe = new JeedEffectRecipeBuilded(new ResourceLocation("twilightdelight", "jeed/" + ForgeRegistries.MOB_EFFECTS.getKey(k).m_135815_()), data);
            pvd.accept((FinishedRecipe)recipe);
        });
    }
}

