/*
 * Decompiled with CFR 0.152.
 */
package com.nakuring.enhanced_boss_bars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nakuring.enhanced_boss_bars.BossBars;
import com.nakuring.enhanced_boss_bars.BossBarsConfig;
import com.nakuring.enhanced_boss_bars.EnhancedBossBars;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enhanced_boss_bars", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CustomBarRenderer {
    private static final ResourceLocation BAR_BACKGROUND = new ResourceLocation("enhanced_boss_bars", "textures/gui/bars/background.png");
    private static final Map<BossEvent, Boolean> SecondFase = new HashMap<BossEvent, Boolean>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCustomGuiOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent EventBoss = event.getBossEvent();
        String BossName = EventBoss.m_18861_().getString();
        for (Map.Entry<String, String> entry : EnhancedBossBars.BossNametoTranslatable.entrySet()) {
            String translatedName = Component.m_237115_((String)entry.getValue()).getString();
            if (BossName.equals(translatedName) && BossBarsConfig.NametoConfig.containsKey(BossName = entry.getKey()) && ((Boolean)BossBarsConfig.NametoConfig.get(BossName).get()).booleanValue()) {
                event.setCanceled(true);
                CustomBarRenderer.prepareBossBar(event, BossBars.BossBarsMap.get(BossName));
            }
            if (!EnhancedBossBars.ModInstalledIDs.contains("aether") || !BossName.contains(translatedName) || !((Boolean)BossBarsConfig.NametoConfig.get(entry.getKey()).get()).booleanValue()) continue;
            event.setCanceled(true);
            CustomBarRenderer.prepareBossBar(event, BossBars.BossBarsMap.get(entry.getKey()));
            return;
        }
    }

    private static void prepareBossBar(CustomizeGuiOverlayEvent.BossEventProgress event, BossBars BossBar) {
        PoseStack Pose = event.getPoseStack();
        LerpingBossEvent EventBoss = event.getBossEvent();
        event.setIncrement(BossBar.getIncrement());
        SecondFase.putIfAbsent((BossEvent)EventBoss, false);
        if (BossBar.hasSecondFase() && (double)EventBoss.m_142717_() < BossBar.getThresholdFase() || SecondFase.get(EventBoss).booleanValue()) {
            SecondFase.put((BossEvent)EventBoss, true);
            CustomBarRenderer.renderHealthBar(Pose, event, BossBar.getBarHealthOffsetX(), event.getY() + BossBar.getBarHealthPosY() - 12, BossBar.getBarHealthWidth(), BossBar.getBarHealthHeight(), BossBar.getSecondBarColor());
            CustomBarRenderer.renderBarOverlay(Pose, event.getY() + BossBar.getBarOverlayPosY() - 12, BossBar.getBarOverlayWidth(), BossBar.getBarOverlayHeight(), BossBar.getSecondBarOverlay());
            return;
        }
        CustomBarRenderer.renderHealthBar(Pose, event, BossBar.getBarHealthOffsetX(), event.getY() + BossBar.getBarHealthPosY() - 12, BossBar.getBarHealthWidth(), BossBar.getBarHealthHeight(), BossBar.getBarColor());
        CustomBarRenderer.renderBarOverlay(Pose, event.getY() + BossBar.getBarOverlayPosY() - 12, BossBar.getBarOverlayWidth(), BossBar.getBarOverlayHeight(), BossBar.getBarOverlay());
    }

    private static void renderHealthBar(PoseStack Pose, CustomizeGuiOverlayEvent.BossEventProgress event, int OffsetX, int y, int Width, int Height, ResourceLocation BAR_COLOR) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BAR_BACKGROUND);
        LerpingBossEvent EventBoss = event.getBossEvent();
        int x = (Minecraft.m_91087_().m_91268_().m_85445_() - Width) / 2 + OffsetX;
        Screen.m_93133_((PoseStack)Pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)Width, (int)Height, (int)Width, (int)Height);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BAR_COLOR);
        if (EventBoss.m_142717_() > 0.0f) {
            Screen.m_93133_((PoseStack)Pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)((int)(EventBoss.m_142717_() * (float)Width)), (int)Height, (int)Width, (int)Height);
        }
        RenderSystem.m_69461_();
    }

    public static void renderBarOverlay(PoseStack Pose, int y, int Width, int Height, ResourceLocation BOSS_TEXTURE) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOSS_TEXTURE);
        int x = (mc.m_91268_().m_85445_() - Width) / 2;
        Screen.m_93133_((PoseStack)Pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)Width, (int)Height, (int)Width, (int)Height);
        RenderSystem.m_69461_();
    }
}

