/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etshtinker.tools.item.tinker;

import com.c2h6s.etshtinker.Entities.ItemProjectile;
import com.c2h6s.etshtinker.Entities.plasmaexplosionentity;
import com.c2h6s.etshtinker.Mapping.ionizerFluidMap;
import com.c2h6s.etshtinker.hooks.FluidConsumptionModifierHook;
import com.c2h6s.etshtinker.hooks.PlasmaExplosionCreateModifierHook;
import com.c2h6s.etshtinker.init.etshtinkerEntity;
import com.c2h6s.etshtinker.init.etshtinkerHook;
import com.c2h6s.etshtinker.init.etshtinkerModifiers;
import com.c2h6s.etshtinker.init.etshtinkerToolStats;
import com.c2h6s.etshtinker.network.handler.packetHandler;
import com.c2h6s.etshtinker.network.packet.FluidChamberSync;
import com.c2h6s.etshtinker.network.packet.IonizedCannonChargeSync;
import com.c2h6s.etshtinker.util.vecCalc;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class IonizedCannon
extends ModifiableItem {
    public IonizedCannon(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        tooltips = this.getIonizedCannonStats(tool, player, tooltips, key, tooltipFlag);
        return tooltips;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (stack.m_41720_() instanceof IonizedCannon && isSelected && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ToolStack tool = ToolStack.from((ItemStack)stack);
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
            int vol = ToolTankHelper.TANK_HELPER.getCapacity((IToolStackView)tool);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("amount", fluidStack.getAmount());
            nbt.m_128405_("max", vol);
            packetHandler.sendToPlayer(new FluidChamberSync(nbt), player);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!IonizedCannon.checkOffHand(playerIn)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        FluidStack fluid2 = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        int fluiddrain = Math.round(((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * 20.0f);
        if (stack.m_41613_() > 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!tool.isBroken()) {
            boolean enoughfluid = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool).getAmount() > fluiddrain;
            boolean iscreative = playerIn.m_7500_();
            if (!worldIn.f_46443_) {
                if (!iscreative && !enoughfluid) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                if (!this.wrongFluid((IToolStackView)tool)) {
                    playerIn.m_6672_(hand);
                    return InteractionResultHolder.m_19096_((Object)stack);
                }
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return new InteractionResultHolder(ToolInventoryCapability.tryOpenContainer((ItemStack)stack, (IToolStackView)tool, (Player)playerIn, (EquipmentSlot)Util.getSlotType((InteractionHand)hand)), (Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.getModifierLevel(etshtinkerModifiers.autoionizing_STATIC_MODIFIER.get()) > 0) {
            return ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool).getAmount() > tool.getStats().getInt((IToolStat)ToolStats.ATTACK_DAMAGE) ? Math.max(1, (int)(40.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue())) : 0;
        }
        return ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool).getAmount() > tool.getStats().getInt((IToolStat)ToolStats.ATTACK_DAMAGE) ? 72000 : 0;
    }

    public int getFluidBaseComsumption(FluidStack fluidStack) {
        int amount = 20;
        Fluid fluid2 = fluidStack.getFluid();
        if (fluid2 != null) {
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.SLIME_TOOLTIPS)) {
                amount = 10;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.SMALL_GEM_TOOLTIPS)) {
                amount = 4;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.LARGE_GEM_TOOLTIPS)) {
                amount = 4;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.METAL_TOOLTIPS)) {
                amount = 3;
            }
        }
        return amount;
    }

    public static int BaseFluidConsumption(Fluid fluid2) {
        int amount = 20;
        if (fluid2 != null) {
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.SLIME_TOOLTIPS)) {
                amount = 10;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.SMALL_GEM_TOOLTIPS)) {
                amount = 4;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.LARGE_GEM_TOOLTIPS)) {
                amount = 4;
            }
            if (fluid2.m_205069_().containsTag(TinkerTags.Fluids.METAL_TOOLTIPS)) {
                amount = 3;
            }
        }
        return amount;
    }

    public static float getDamageMultiplier(ToolStack tool) {
        return (1.0f + ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.DAMAGEMULTIPLIER)).floatValue()) * IonizedCannon.getToolFluidMultiplier(tool);
    }

    public static float getToolFluidMultiplier(ToolStack tool) {
        return Math.min(1.0f + ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * 0.2f, 4.5f);
    }

    public void createPlasmaExplosion(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            packetHandler.sendToPlayer(new IonizedCannonChargeSync(0.0f), player);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        Fluid fluid2 = fluidStack.getFluid();
        int times = tool.getStats().getInt((IToolStat)etshtinkerToolStats.MULTIPLASMA);
        int consumption = Math.round(IonizedCannon.getToolFluidMultiplier(tool) * (float)this.getFluidBaseComsumption(fluidStack) * (float)tool.getStats().getInt((IToolStat)etshtinkerToolStats.FLUIDMULTIPLIER));
        consumption = Math.max(1, consumption);
        for (int a = 0; a <= times && living instanceof Player; ++a) {
            Object modifier2;
            Player player = (Player)living;
            for (Object modifier2 : tool.getModifierList()) {
                consumption = ((FluidConsumptionModifierHook)modifier2.getHook(etshtinkerHook.FLUID_CONSUMPTION)).getFluidConsumption((IToolStackView)tool, fluidStack, player, consumption, consumption);
            }
            if (timeLeft > this.m_8105_(stack) - (int)(40.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue()) || ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool).getAmount() <= consumption) continue;
            plasmaexplosionentity entity = new plasmaexplosionentity((EntityType<? extends ItemProjectile>)((EntityType)etshtinkerEntity.plasmaexplosionentity.get()), level);
            entity.rayVec3 = ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.SCATTER)).floatValue() > 0.0f ? vecCalc.getScatteredVec3(living.m_20154_().m_82490_((double)((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.PLASMARANGE)).floatValue()), Math.tan(((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.SCATTER)).floatValue())) : living.m_20154_().m_82490_((double)((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.PLASMARANGE)).floatValue());
            entity.particle = ionizerFluidMap.getFluidparticle(fluid2);
            entity.scale = ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.SCALE)).floatValue();
            entity.damage = ionizerFluidMap.getFluidDamage(fluid2) * IonizedCannon.getDamageMultiplier(tool);
            entity.tool = tool;
            entity.special = ionizerFluidMap.getFluidSpecial(fluid2);
            entity.m_6034_(living.m_146892_().f_82479_, living.m_146892_().f_82480_ - 0.5 * (double)entity.m_20206_(), living.m_146892_().f_82481_);
            entity.m_5602_((Entity)living);
            modifier2 = tool.getModifierList().iterator();
            while (modifier2.hasNext()) {
                ModifierEntry modifier3 = (ModifierEntry)modifier2.next();
                entity = ((PlasmaExplosionCreateModifierHook)modifier3.getHook(etshtinkerHook.PLASMA_EXPLOSION_CREATE)).plasmaExplosionCreate((IToolStackView)tool, fluidStack, player, entity);
            }
            level.m_7967_((Entity)entity);
            living.m_5496_(SoundEvents.f_215771_, 1.0f, 1.0f);
            player.m_36335_().m_41524_(stack.m_41720_(), tool.getStats().getInt((IToolStat)etshtinkerToolStats.COOLDOWN));
            FluidStack fluidStack2 = new FluidStack(ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool), ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool).getAmount() - consumption);
            ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, fluidStack2);
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        this.createPlasmaExplosion(stack, level, living, timeLeft);
    }

    public boolean wrongFluid(IToolStackView tool) {
        Fluid fluid2 = ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid();
        return ionizerFluidMap.getFluidparticle(fluid2) == null;
    }

    public boolean noFluid(IToolStackView tool) {
        FluidStack fluid2 = ToolTankHelper.TANK_HELPER.getFluid(tool);
        return fluid2.getAmount() <= 0;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int chargeRemaining) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        Level world = living.f_19853_;
        if (this.m_8105_(stack) - chargeRemaining == (int)(40.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue())) {
            living.m_5496_(SoundEvents.f_215774_, 1.0f, 1.0f);
            Vec3 pos = living.m_146892_();
            Vec3 ang = living.m_20154_();
            double x = pos.f_82479_ + ang.f_82479_;
            double y = pos.f_82480_ + ang.f_82480_;
            double z = pos.f_82481_ + ang.f_82481_;
            world.m_6485_((ParticleOptions)ParticleTypes.f_175830_, true, x, y, z, 0.0, 0.0, 0.0);
        }
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            float perc = Mth.m_14036_((float)((float)(this.m_8105_(stack) - chargeRemaining) / (40.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue())), (float)0.0f, (float)1.0f);
            packetHandler.sendToPlayer(new IonizedCannonChargeSync(perc), player);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            packetHandler.sendToPlayer(new IonizedCannonChargeSync(0.0f), player);
        }
        if (tool.getModifierLevel(etshtinkerModifiers.autoionizing_STATIC_MODIFIER.get()) > 0) {
            this.createPlasmaExplosion(stack, level, living, 0);
        }
        return stack;
    }

    public static boolean checkOffHand(Player player) {
        return player != null && !(player.m_21206_().m_41720_() instanceof IModifiable);
    }

    public List<Component> getIonizedCannonStats(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.add((IToolStat)ToolStats.DURABILITY);
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.add((IToolStat)ToolStats.ATTACK_DAMAGE);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.plasmarange").m_130946_(":" + String.format("%.01f", tool.getStats().get((IToolStat)etshtinkerToolStats.PLASMARANGE))));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.damagemultiplier").m_130946_(":" + String.format("%.01f", Float.valueOf(IonizedCannon.getDamageMultiplier((ToolStack)tool)))));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.chargespeed").m_130946_(":" + String.valueOf((int)(40.0f / ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue()))));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.cooldown").m_130946_(":" + String.valueOf(tool.getStats().get((IToolStat)etshtinkerToolStats.COOLDOWN))).m_130940_(ChatFormatting.GOLD));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.scatter").m_130946_(":" + String.format("%.01f", tool.getStats().get((IToolStat)etshtinkerToolStats.SCATTER))).m_130940_(ChatFormatting.GOLD));
        builder.addAllFreeSlots();
        if (!IonizedCannon.checkOffHand(player)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.offhand_hastool").m_130940_(ChatFormatting.RED));
        }
        if (!this.wrongFluid(tool)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.powerfactor").m_130946_(":" + String.valueOf(Math.max(1, Math.round(IonizedCannon.getToolFluidMultiplier((ToolStack)tool) * (float)this.getFluidBaseComsumption(ToolTankHelper.TANK_HELPER.getFluid(tool)) * (float)tool.getStats().getInt((IToolStat)etshtinkerToolStats.FLUIDMULTIPLIER))))).m_130946_(" mB").m_130940_(ChatFormatting.GOLD));
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.effectivefluid").m_130946_(":" + String.format("%.001f", Float.valueOf(ionizerFluidMap.getFluidDamage(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid())))).m_130940_(ChatFormatting.GREEN));
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.fluid_consumption").m_130946_(":" + String.valueOf(this.getFluidBaseComsumption(ToolTankHelper.TANK_HELPER.getFluid(tool)))).m_130946_(" mB").m_130940_(ChatFormatting.YELLOW));
            if (ionizerFluidMap.getFluidSpecial(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid()) != null) {
                builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.fluidhasspecial").m_130946_(":").m_7220_((Component)Component.m_237115_((String)("etshtinker.tool.tooltip.fluidspecial." + ionizerFluidMap.getFluidSpecial(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid())))).m_130940_(ChatFormatting.AQUA));
            }
        } else if (this.noFluid(tool)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.nofluid").m_130940_(ChatFormatting.RED));
        } else {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.wrongfluid").m_130940_(ChatFormatting.RED));
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }
}

