/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etshtinker.tools.item.tinker;

import com.c2h6s.etshtinker.Entities.PlasmaSlashEntity;
import com.c2h6s.etshtinker.hooks.FluidConsumptionModifierHook;
import com.c2h6s.etshtinker.hooks.PlasmaSlashCreateModifierHook;
import com.c2h6s.etshtinker.init.etshtinkerHook;
import com.c2h6s.etshtinker.init.etshtinkerToolStats;
import com.c2h6s.etshtinker.network.handler.packetHandler;
import com.c2h6s.etshtinker.network.packet.FluidChamberSync;
import com.c2h6s.etshtinker.network.packet.plasmaSlashPacket;
import com.c2h6s.etshtinker.util.SlashColor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;

public class ConstrainedPlasmaSaber
extends ModifiableSwordItem {
    public ConstrainedPlasmaSaber(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
        MinecraftForge.EVENT_BUS.addListener(this::LeftClick);
        MinecraftForge.EVENT_BUS.addListener(this::LeftClickBlock);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (stack.m_41720_() instanceof ConstrainedPlasmaSaber && isSelected && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ToolStack tool = ToolStack.from((ItemStack)stack);
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
            int vol = ToolTankHelper.TANK_HELPER.getCapacity((IToolStackView)tool);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("amount", fluidStack.getAmount());
            nbt.m_128405_("max", vol);
            packetHandler.sendToPlayer(new FluidChamberSync(nbt), player);
        }
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        tooltips = this.getPlasmaSaberStats(tool, player, tooltips, key, tooltipFlag);
        return tooltips;
    }

    private void LeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity() != null && event.getEntity().m_21205_().m_41720_() instanceof ConstrainedPlasmaSaber) {
            packetHandler.INSTANCE.sendToServer((Object)new plasmaSlashPacket());
        }
    }

    private void LeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity() != null && event.getEntity().m_21205_().m_41720_() instanceof ConstrainedPlasmaSaber) {
            packetHandler.INSTANCE.sendToServer((Object)new plasmaSlashPacket());
        }
    }

    public static float getDamageMultiplier(ToolStack tool) {
        return (1.0f + ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.DAMAGEMULTIPLIER)).floatValue()) * ConstrainedPlasmaSaber.getToolFluidMultiplier(tool);
    }

    public static float getToolFluidMultiplier(ToolStack tool) {
        return Math.min(1.0f + ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue() * 0.1f, 1.5f);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ConstrainedPlasmaSaber.createSlash(serverPlayer);
        }
        return super.onLeftClickEntity(stack, player, target);
    }

    public static void createSlash(ServerPlayer player) {
        if (!(player.m_21205_().m_41720_() instanceof ConstrainedPlasmaSaber) || player.m_36403_(0.0f) != 1.0f || !ConstrainedPlasmaSaber.checkOffHand((Player)player)) {
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)player.m_21205_());
        if (!ConstrainedPlasmaSaber.checkFluid((IToolStackView)tool) || tool.isBroken()) {
            return;
        }
        FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        MeltingFuel fuel = ConstrainedPlasmaSaber.getFuel(fluidStack.getFluid());
        int consumption = ConstrainedPlasmaSaber.getFuelCumsp(fuel, fluidStack.getFluid(), (IToolStackView)tool);
        for (ModifierEntry modifier : tool.getModifierList()) {
            consumption = ((FluidConsumptionModifierHook)modifier.getHook(etshtinkerHook.FLUID_CONSUMPTION)).getFluidConsumption((IToolStackView)tool, fluidStack, (Player)player, consumption, consumption);
        }
        if (fluidStack.getAmount() < consumption) {
            return;
        }
        float damage = ConstrainedPlasmaSaber.getFuelDamage(fuel) * ConstrainedPlasmaSaber.getDamageMultiplier(tool);
        ItemStack color = SlashColor.getSlash(tool.getStats().getInt((IToolStat)etshtinkerToolStats.SLASH_COLOR));
        ServerLevel level = player.m_9236_();
        EntityType<PlasmaSlashEntity> entityType = SlashColor.getSlashType(tool.getStats().getInt((IToolStat)etshtinkerToolStats.SLASH_COLOR));
        PlasmaSlashEntity slash = new PlasmaSlashEntity(entityType, (Level)level, color);
        slash.damage = damage;
        slash.m_5602_((Entity)player);
        slash.m_20256_(player.m_20154_().m_82490_((double)tool.getModifierLevel(ModifierIds.reach) * 0.5 + 1.0));
        slash.setToolstack(tool);
        slash.CriticalRate = ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.CRITICAL_RATE)).floatValue();
        double x = player.m_20154_().f_82479_;
        double y = player.m_20154_().f_82480_;
        double z = player.m_20154_().f_82481_;
        slash.m_6034_(player.m_20185_() + x * 1.5, player.m_20186_() + 0.6 * (double)player.m_20206_() + y * 1.5, player.m_20189_() + z * 1.5);
        for (ModifierEntry modifier : tool.getModifierList()) {
            slash = ((PlasmaSlashCreateModifierHook)modifier.getHook(etshtinkerHook.SLASH_CREATE)).plasmaSlashCreate((IToolStackView)tool, fluidStack, player, slash);
        }
        level.m_7967_((Entity)slash);
        fluidStack.shrink(consumption);
        ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, fluidStack);
        ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
    }

    public static boolean checkOffHand(Player player) {
        return player != null && !(player.m_21206_().m_41720_() instanceof IModifiable);
    }

    public static boolean noFluid(IToolStackView tool) {
        FluidStack fluid2 = ToolTankHelper.TANK_HELPER.getFluid(tool);
        return fluid2.getAmount() <= 0;
    }

    public static boolean checkFluid(IToolStackView tool) {
        Fluid fluid2 = ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid();
        return MeltingFuelLookup.isFuel((Fluid)fluid2);
    }

    public static MeltingFuel getFuel(Fluid fluid2) {
        return MeltingFuelLookup.findFuel((Fluid)fluid2);
    }

    public static float getFuelDamage(MeltingFuel fuel) {
        return (float)fuel.getTemperature() * 8.5E-4f;
    }

    public static int getFuelCumsp(MeltingFuel fuel, Fluid fluid2, IToolStackView tool) {
        return (int)Math.max((float)fuel.getAmount(fluid2) * ConstrainedPlasmaSaber.getToolFluidMultiplier((ToolStack)tool) * 20.0f / ((float)fuel.getDuration() * ((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.FLUID_EFFICIENCY)).floatValue()), 1.0f);
    }

    public List<Component> getPlasmaSaberStats(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.add((IToolStat)ToolStats.DURABILITY);
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.add((IToolStat)ToolStats.ATTACK_DAMAGE);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.damagemultiplier").m_130946_(":" + String.format("%.2f", Float.valueOf(ConstrainedPlasmaSaber.getDamageMultiplier((ToolStack)tool)))));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.critical_rate").m_130946_(":" + String.format("%.2f", Float.valueOf(((Float)tool.getStats().get((IToolStat)etshtinkerToolStats.CRITICAL_RATE)).floatValue() * 100.0f)) + "%").m_130940_(ChatFormatting.AQUA));
        builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.fluid_efficiency").m_130946_(":" + String.format("%.2f", tool.getStats().get((IToolStat)etshtinkerToolStats.FLUID_EFFICIENCY))).m_130940_(ChatFormatting.DARK_AQUA));
        builder.addAllFreeSlots();
        if (!ConstrainedPlasmaSaber.checkOffHand(player)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.offhand_hastool").m_130940_(ChatFormatting.RED));
        } else if (ConstrainedPlasmaSaber.checkFluid(tool)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.effectivefluid").m_130946_(":" + String.format("%.2f", Float.valueOf(ConstrainedPlasmaSaber.getFuelDamage(ConstrainedPlasmaSaber.getFuel(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid()))))).m_130940_(ChatFormatting.GOLD));
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.powerfactor").m_130946_(":" + String.valueOf(ConstrainedPlasmaSaber.getFuelCumsp(ConstrainedPlasmaSaber.getFuel(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid()), ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid(), tool))).m_130946_(" mB").m_130940_(ChatFormatting.YELLOW));
        } else if (ConstrainedPlasmaSaber.noFluid(tool)) {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.nofluid").m_130940_(ChatFormatting.RED));
        } else {
            builder.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.wrongfluid").m_130940_(ChatFormatting.RED));
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }
}

