/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etshtinker.mixin;

import com.c2h6s.etshtinker.capability.IDampenCapability;
import com.c2h6s.etshtinker.capability.etshCap;
import com.c2h6s.etshtinker.init.etshtinkerEffects;
import com.c2h6s.etshtinker.util.Cap;
import com.c2h6s.etshtinker.util.ParticleChainUtil;
import com.c2h6s.etshtinker.util.vecCalc;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"dampensVibrations"}, cancellable=true)
    public void etshDampen(CallbackInfoReturnable<Boolean> callbackinfo) {
        float dampen = 0.0f;
        List<EquipmentSlot> Slots = List.of(EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.HEAD, EquipmentSlot.LEGS, EquipmentSlot.MAINHAND, EquipmentSlot.MAINHAND);
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (EquipmentSlot slot : Slots) {
                ItemStack stack = living.m_6844_(slot);
                Optional capability = Cap.getCapability((ICapabilityProvider)stack, etshCap.DAMPEN_CAPABILITY, null).resolve();
                if (!capability.isPresent()) continue;
                dampen += ((IDampenCapability)capability.get()).getDampenCap();
            }
        }
        callbackinfo.setReturnValue((Object)(dampen >= 1.0f ? 1 : 0));
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    public void rejectInvulerable(DamageSource p_20122_, CallbackInfoReturnable<Boolean> cir) {
        block4: {
            LivingEntity living;
            block5: {
                Entity entity = (Entity)this;
                if (!(entity instanceof LivingEntity)) break block4;
                living = (LivingEntity)entity;
                if (!(entity instanceof Player)) break block5;
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) break block4;
            }
            if (living.m_21023_((MobEffect)etshtinkerEffects.ionized.get()) || living.m_21023_((MobEffect)etshtinkerEffects.novaradiation.get())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        AbstractArrow arrow;
        Entity entity0 = (Entity)this;
        if (entity0 instanceof AbstractArrow && (arrow = (AbstractArrow)entity0).m_19880_().contains("warping") && arrow.f_36702_ != null && arrow.f_36702_.size() < arrow.m_36796_() + 1) {
            arrow.m_20137_("warping");
            LivingEntity entity = vecCalc.getNearestLiEntWithEntBL(Float.valueOf(16.0f), (Entity)arrow, arrow.f_19853_, arrow.f_36702_);
            if (entity != null) {
                Level level = arrow.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleChainUtil.SummonParticleChain(serverLevel, arrow.m_20182_(), entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0), ParticleTypes.f_175830_);
                }
                arrow.m_6034_(entity.m_20185_(), entity.m_20186_() + 0.5 * (double)entity.m_20206_(), entity.m_20189_());
                EntityHitResult entityHitResult = new EntityHitResult((Entity)entity);
                ForgeEventFactory.onProjectileImpact((Projectile)arrow, (HitResult)entityHitResult);
                arrow.m_6532_((HitResult)entityHitResult);
                arrow.f_36702_.add(entity);
            }
        }
    }
}

