/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etshtinker.Modifiers;

import com.c2h6s.etshtinker.init.etshtinkerModifiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ToolDefinitions;

public class PlasmaArrowModifier
extends Modifier
implements ProjectileLaunchModifierHook,
TooltipModifierHook {
    public int getPriority() {
        return 25600;
    }

    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.TOOLTIP);
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifiers, LivingEntity livingEntity, Projectile projectile, @Nullable AbstractArrow abstractArrow, NamespacedNBT namespacedNBT, boolean primary) {
        if (PlasmaArrowModifier.ValidateFluid((ToolStack)tool, modifiers.getLevel())) {
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid(tool);
            fluidStack.shrink(10 * modifiers.getLevel());
            ToolTankHelper.TANK_HELPER.setFluid(tool, fluidStack);
        }
    }

    public static boolean ValidateFluid(ToolStack toolStack, int level) {
        MaterialVariant variant = MaterialVariant.UNKNOWN;
        if (!ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)toolStack).isEmpty()) {
            MaterialFluidRecipe recipe = PlasmaArrowModifier.getFluidMaterial(ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)toolStack).getFluid());
            variant = recipe.getOutput();
        }
        return !variant.isUnknown() && !variant.isEmpty() && !PlasmaArrowModifier.getFluidModifiers(toolStack, level).isEmpty();
    }

    public static MaterialFluidRecipe getFluidMaterial(Fluid fluid2) {
        return MaterialCastingLookup.getCastingFluid((Fluid)fluid2);
    }

    public static List<ModifierEntry> getFluidModifiers(ToolStack toolStack, int level) {
        FluidStack fluidStack;
        MaterialFluidRecipe recipe;
        MaterialVariant variant;
        ArrayList<ModifierEntry> list = new ArrayList<ModifierEntry>(List.of());
        if (!(ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)toolStack).isEmpty() || (variant = (recipe = PlasmaArrowModifier.getFluidMaterial(ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)toolStack).getFluid())).getOutput()).isUnknown() || variant.isEmpty() || (fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)toolStack)).getAmount() < 20)) {
            ToolStack tool = ToolStack.createTool((Item)((Item)TinkerTools.longbow.get()), (ToolDefinition)ToolDefinitions.LONGBOW, (MaterialNBT)new MaterialNBT(List.of(variant, variant, variant)));
            ToolStack slotValidate = toolStack.copy();
            for (ModifierEntry entry1 : tool.getModifierList()) {
                slotValidate.addModifier(entry1.getId(), entry1.getLevel());
            }
            for (SlotType slotType : SlotType.getAllSlotTypes()) {
                if (slotValidate.getVolatileData().getSlots(slotType) == toolStack.getVolatileData().getSlots(slotType)) continue;
                return list;
            }
            for (ModifierEntry entry1 : tool.getModifierList()) {
                if (entry1.getModifier() == etshtinkerModifiers.godlymetal_STATIC_MODIFIER.get()) continue;
                entry1 = new ModifierEntry(entry1.getId(), level);
                list.add(entry1);
            }
        }
        return list;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (!ToolTankHelper.TANK_HELPER.getFluid(tool).isEmpty() && player != null && tooltipKey == TooltipKey.SHIFT) {
            MaterialFluidRecipe recipe = PlasmaArrowModifier.getFluidMaterial(ToolTankHelper.TANK_HELPER.getFluid(tool).getFluid());
            MaterialVariant variant = recipe.getOutput();
            List<ModifierEntry> list = PlasmaArrowModifier.getFluidModifiers((ToolStack)tool, modifierEntry.getLevel());
            if (!list.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.fluid_contains_modifier").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130946_(" : ").m_130940_(ChatFormatting.BOLD).m_7220_((Component)Component.m_237115_((String)("material." + variant.getId().m_214298_()))));
                for (ModifierEntry entry : list) {
                    if (entry == null) continue;
                    entry = new ModifierEntry(entry.getId(), modifierEntry.getLevel());
                    Component component = entry.getDisplayName();
                    tooltip.add(component);
                }
            } else if (!variant.isEmpty() && !variant.isUnknown()) {
                tooltip.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.material_unsupport").m_130940_(ChatFormatting.RED).m_130946_(" : ").m_7220_((Component)Component.m_237115_((String)("material." + variant.getId().m_214298_()))));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"etshtinker.tool.tooltip.fluid_not_modifier").m_130940_(ChatFormatting.GOLD));
            }
        }
    }
}

