/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class JsonUtil {
    public static FluidStack readFluid(JsonObject json, String key) {
        return JsonUtil.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static JsonElement toJson(FluidStack stack) {
        return (JsonElement)FluidStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).result().orElseThrow();
    }

    public static FluidStack deserializeFluid(@NotNull JsonObject json) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!GsonHelper.m_13872_((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        int amount = count.getAsJsonPrimitive().getAsInt();
        if (amount < 1) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid type '" + resourceLocation + "'");
        }
        return new FluidStack(fluid, amount);
    }
}

