/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeUtil {
    public static final ResourceKey<Biome> VENUS_BARRENS = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("ad_astra", "infernal_venus_barrens"));
    public static final ResourceKey<Biome> VENUS_WASTELAND = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("ad_astra", "venus_wastelands"));
    public static final ResourceKey<Biome> GLACIO_BARRENS = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("ad_astra", "glacio_snowy_barrens"));
    public static final ResourceKey<Biome> GLACIO_ICE = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("ad_astra", "glacio_ice_peaks"));
    public static final ResourceKey<Biome> IONIZED_MARE = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "ionized_mare"));
    public static final ResourceKey<Biome> IONIZED_GLACIO = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "ionized_glacio"));
    public static final ResourceKey<Biome> DISORDERED_ZONE = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "disordered_zone"));
    public static final ResourceKey<Biome> INFERNAL = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "infernal"));
    public static final ResourceKey<Biome> INFERNAL_MOLTEN = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "infernal_molten_surface"));
    public static final ResourceKey<Biome> JUPITER = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "jupiter"));
    public static final ResourceKey<Biome> URANUS = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("cti", "uranus"));
    public static final Map<ResourceKey<Biome>, Float> IONIZE_LEVEL = new HashMap<ResourceKey<Biome>, Float>();
    public static final Map<ResourceKey<Biome>, Float> SCORCH_LEVEL = new HashMap<ResourceKey<Biome>, Float>();
    public static final Map<ResourceKey<Biome>, Float> FREEZE_LEVEL = new HashMap<ResourceKey<Biome>, Float>();
    public static final Map<ResourceKey<Biome>, Float> PRESSURE_LEVEL = new HashMap<ResourceKey<Biome>, Float>();

    public static void init() {
        IONIZE_LEVEL.put(IONIZED_MARE, Float.valueOf(2.1f));
        IONIZE_LEVEL.put(IONIZED_GLACIO, Float.valueOf(0.8f));
        IONIZE_LEVEL.put(DISORDERED_ZONE, Float.valueOf(3.5f));
        SCORCH_LEVEL.put(INFERNAL_MOLTEN, Float.valueOf(3.5f));
        SCORCH_LEVEL.put(INFERNAL, Float.valueOf(2.1f));
        SCORCH_LEVEL.put(JUPITER, Float.valueOf(3.8f));
        FREEZE_LEVEL.put(IONIZED_MARE, Float.valueOf(2.2f));
        FREEZE_LEVEL.put(IONIZED_GLACIO, Float.valueOf(3.9f));
        FREEZE_LEVEL.put(DISORDERED_ZONE, Float.valueOf(1.1f));
        FREEZE_LEVEL.put(URANUS, Float.valueOf(1.9f));
        PRESSURE_LEVEL.put(JUPITER, Float.valueOf(3.25f));
        PRESSURE_LEVEL.put(URANUS, Float.valueOf(1.8f));
    }

    public static String BiomekeyToString(ResourceKey<Biome> key) {
        return key != null ? "biome." + key.m_135782_().m_214298_() : "cti.gui.biome.null";
    }

    public static float getBiomeIonizeLevel(Holder<Biome> holder) {
        ResourceKey<Biome> key = BiomeUtil.getBiomeKey(holder);
        return key != null ? IONIZE_LEVEL.getOrDefault(key, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    public static float getBiomeScorchLevel(Holder<Biome> holder) {
        ResourceKey<Biome> key = BiomeUtil.getBiomeKey(holder);
        return key != null ? SCORCH_LEVEL.getOrDefault(key, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    public static float getBiomeFreezeLevel(Holder<Biome> holder) {
        ResourceKey<Biome> key = BiomeUtil.getBiomeKey(holder);
        return key != null ? FREEZE_LEVEL.getOrDefault(key, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    public static float getBiomePressureLevel(Holder<Biome> holder) {
        ResourceKey<Biome> key = BiomeUtil.getBiomeKey(holder);
        return key != null ? PRESSURE_LEVEL.getOrDefault(key, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    @Nullable
    public static ResourceKey<Biome> getBiomeKey(Holder<Biome> holder) {
        ResourceKey key = null;
        if (holder.m_203543_().isPresent()) {
            key = (ResourceKey)holder.m_203543_().get();
        }
        return key;
    }
}

