/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.recipe;

import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.init.registry.ModItems;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ReactorNeutronCollectorRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ItemStack catalyst;
    private final float consumption_rate;
    private final float efficiency;
    private final Ingredient ingredient = Ingredient.f_43901_;

    public ReactorNeutronCollectorRecipe(ResourceLocation id, ItemStack output, float efficiency, float consumption, ItemStack catalyst) {
        this.id = id;
        this.output = output;
        this.efficiency = efficiency;
        this.consumption_rate = consumption;
        this.catalyst = catalyst;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return !pLevel.m_5776_();
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getConsumptionRate() {
        return this.consumption_rate;
    }

    public ItemStack assemble(SimpleContainer pContainer) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ItemStack getCatalyst() {
        return this.catalyst.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Deprecated
    public static class Serializer
    implements RecipeSerializer<ReactorNeutronCollectorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("cti", "reactor_neutron_collect");

        public ReactorNeutronCollectorRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = new ItemStack((ItemLike)ModItems.neutron_pile.get());
            float efficiency = GsonHelper.m_13915_((JsonObject)pSerializedRecipe, (String)"efficiency");
            float consumption = GsonHelper.m_13915_((JsonObject)pSerializedRecipe, (String)"consumption_rate");
            ItemStack catalyst = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"catalyst"));
            return new ReactorNeutronCollectorRecipe(pRecipeId, output, efficiency, consumption, catalyst);
        }

        @Nullable
        public ReactorNeutronCollectorRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack output = new ItemStack((ItemLike)ModItems.neutron_pile.get());
            float efficiency = pBuffer.readFloat();
            float consumption_rate = (float)pBuffer.readDouble();
            ItemStack catalyst = pBuffer.m_130267_();
            return new ReactorNeutronCollectorRecipe(pRecipeId, output, efficiency, consumption_rate, catalyst);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ReactorNeutronCollectorRecipe pRecipe) {
            pBuffer.m_130085_(pRecipe.id);
            pBuffer.writeInt(pRecipe.m_7527_().size());
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.writeFloat(pRecipe.efficiency);
            pBuffer.writeDouble((double)pRecipe.consumption_rate);
            pBuffer.writeItemStack(pRecipe.getCatalyst(), false);
        }
    }

    public static class Type
    implements RecipeType<ReactorNeutronCollectorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "reactor_neutron_collect";

        private Type() {
        }
    }
}

