/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class QuantumMinerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final float chance;
    private final Ingredient ingredient = Ingredient.f_43901_;

    public QuantumMinerRecipe(ResourceLocation id, ItemStack output, float chance) {
        this.id = id;
        this.output = output;
        this.chance = chance;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return !pLevel.m_5776_();
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack assemble(SimpleContainer pContainer) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Deprecated
    public static class Serializer
    implements RecipeSerializer<QuantumMinerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("cti", "quantum_mining");

        public QuantumMinerRecipe fromJson(@NotNull ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            float chance = GsonHelper.m_13915_((JsonObject)pSerializedRecipe, (String)"chance");
            return new QuantumMinerRecipe(pRecipeId, output, chance);
        }

        @Nullable
        public QuantumMinerRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack output = pBuffer.m_130267_();
            float chance = pBuffer.readFloat();
            return new QuantumMinerRecipe(pRecipeId, output, chance);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, QuantumMinerRecipe pRecipe) {
            pBuffer.m_130085_(pRecipe.id);
            pBuffer.writeInt(pRecipe.m_7527_().size());
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.writeItemStack(pRecipe.m_8043_(), false);
            pBuffer.writeFloat(pRecipe.chance);
        }
    }

    public static class Type
    implements RecipeType<QuantumMinerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "quantum_mining";

        private Type() {
        }
    }
}

