/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin;

import com.hoshino.cti.Entity.Systems.EnvironmentSystem;
import earth.terrarium.ad_astra.common.registry.ModDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void setInvulnerableTo(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            Player living = (Player)entity;
            if ((double)EnvironmentSystem.getScorchResistance((LivingEntity)living) > 0.5 && source.m_19384_()) {
                cir.setReturnValue((Object)true);
            }
            if ((double)EnvironmentSystem.getFreezeResistance((LivingEntity)living) > 0.5 && (source == ModDamageSource.CRYO_FUEL || source == DamageSource.f_146701_)) {
                cir.setReturnValue((Object)true);
            }
        } else if (entity != null && entity.getPersistentData().m_128471_("vulnerable")) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"fireImmune"}, cancellable=true)
    private void setFireImmune(CallbackInfoReturnable<Boolean> cir) {
        Player living;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (double)EnvironmentSystem.getScorchResistance((LivingEntity)(living = (Player)entity)) > 0.5) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void setFreezeImmune(CallbackInfoReturnable<Boolean> cir) {
        Player living;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (double)EnvironmentSystem.getFreezeResistance((LivingEntity)(living = (Player)entity)) > 0.5) {
            cir.setReturnValue((Object)false);
        }
    }
}

