/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Plugin;

import com.hoshino.cti.integration.AtmosphereCondenseRecipeCategory;
import com.hoshino.cti.integration.AtmosphereExtractRecipeCategory;
import com.hoshino.cti.integration.QuantumMinerRecipeCategory;
import com.hoshino.cti.integration.ReactorNeutronCollectorRecipeCategory;
import com.hoshino.cti.recipe.AtmosphereCondensorRecipe;
import com.hoshino.cti.recipe.AtmosphereExtractorRecipe;
import com.hoshino.cti.recipe.QuantumMinerRecipe;
import com.hoshino.cti.recipe.ReactorNeutronCollectorRecipe;
import com.hoshino.cti.recipe.RecipeMap;
import com.hoshino.cti.register.ctiItem;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static RecipeType<AtmosphereExtractorRecipe> ATMOSPHERE_EXTRACT = new RecipeType(AtmosphereExtractRecipeCategory.UID, AtmosphereExtractorRecipe.class);
    public static RecipeType<AtmosphereCondensorRecipe> ATMOSPHERE_CONDENSE = new RecipeType(AtmosphereCondenseRecipeCategory.UID, AtmosphereCondensorRecipe.class);
    public static RecipeType<QuantumMinerRecipe> QUANTUM_MINING = new RecipeType(QuantumMinerRecipeCategory.UID, QuantumMinerRecipe.class);
    public static RecipeType<ReactorNeutronCollectorRecipe> NEUTRON_COLLECTING = new RecipeType(ReactorNeutronCollectorRecipeCategory.UID, ReactorNeutronCollectorRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("cti", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AtmosphereExtractRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AtmosphereCondenseRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QuantumMinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReactorNeutronCollectorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<AtmosphereExtractorRecipe> recipesExtract = List.copyOf(RecipeMap.ExtractorRecipeList);
        List<AtmosphereCondensorRecipe> recipesCondense = List.copyOf(RecipeMap.CondensorRecipeList);
        List<QuantumMinerRecipe> quantumMining = List.copyOf(RecipeMap.MinerRecipeList);
        List<ReactorNeutronCollectorRecipe> neutronCollecting = List.copyOf(RecipeMap.NeutronRecipeList);
        registration.addRecipes(ATMOSPHERE_EXTRACT, recipesExtract);
        registration.addRecipes(ATMOSPHERE_CONDENSE, recipesCondense);
        registration.addRecipes(QUANTUM_MINING, quantumMining);
        registration.addRecipes(NEUTRON_COLLECTING, neutronCollecting);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ctiItem.atmosphere_extractor.get()), new RecipeType[]{ATMOSPHERE_EXTRACT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ctiItem.atmosphere_condensator.get()), new RecipeType[]{ATMOSPHERE_CONDENSE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ctiItem.quantum_miner.get()), new RecipeType[]{QUANTUM_MINING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ctiItem.quantum_miner_advanced.get()), new RecipeType[]{QUANTUM_MINING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ctiItem.reactor_neutron_collector.get()), new RecipeType[]{NEUTRON_COLLECTING});
    }
}

