/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Event;

import com.hoshino.cti.Entity.DisposibleFakePlayer;
import com.hoshino.cti.Entity.specialDamageSource.Environmental;
import com.hoshino.cti.Entity.specialDamageSource.PierceThrough;
import com.hoshino.cti.register.ctiEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class LivingEvents {
    public LivingEvents() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onPierceDamage);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onPierceAttack);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onPierceHurt);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onFakePlayerHurt);
    }

    private void onFakePlayerHurt(LivingHurtEvent event) {
        FakePlayer fakePlayer;
        Entity entity;
        if (event.getEntity().m_21233_() > 10000.0f && (entity = event.getSource().m_7639_()) instanceof FakePlayer && !((fakePlayer = (FakePlayer)entity) instanceof DisposibleFakePlayer)) {
            event.setCanceled(true);
        }
    }

    private void onPierceHurt(LivingHurtEvent event) {
        DamageSource damageSource;
        Player player;
        MobEffectInstance instance;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (instance = (player = (Player)livingEntity).m_21124_((MobEffect)ctiEffects.stress.get())) != null && instance.m_19557_() > 0) {
            int level = instance.m_19564_() + 1;
            float red = Math.max(0.9f, 1.0f - 0.04f * (float)level);
            event.setAmount(event.getAmount() * red);
        }
        if ((damageSource = event.getSource()) instanceof PierceThrough) {
            PierceThrough source = (PierceThrough)damageSource;
            event.setAmount(source.getAMOUNT());
            event.setCanceled(false);
        } else {
            damageSource = event.getSource();
            if (damageSource instanceof Environmental) {
                Environmental source = (Environmental)damageSource;
                event.setAmount(source.getAMOUNT());
                event.setCanceled(false);
            }
        }
        livingEntity = event.getEntity();
        if (livingEntity instanceof Warden) {
            Warden warden = (Warden)livingEntity;
            if (event.getSource().m_19385_().equals("sonic_boom")) {
                event.setAmount(warden.m_21233_() / 4.0f);
            }
        }
    }

    private void onPierceAttack(LivingAttackEvent event) {
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof PierceThrough) {
            PierceThrough source = (PierceThrough)damageSource;
            event.setCanceled(false);
        } else {
            damageSource = event.getSource();
            if (damageSource instanceof Environmental) {
                Environmental source = (Environmental)damageSource;
                event.setCanceled(false);
            }
        }
    }

    public void onPierceDamage(LivingDamageEvent event) {
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof PierceThrough) {
            PierceThrough source = (PierceThrough)damageSource;
            event.setAmount(source.getAMOUNT());
            event.setCanceled(false);
        } else {
            damageSource = event.getSource();
            if (damageSource instanceof Environmental) {
                Environmental source = (Environmental)damageSource;
                event.setAmount(source.getAMOUNT());
                event.setCanceled(false);
            }
        }
    }
}

