/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Entity.Systems;

import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import com.c2h6s.etshtinker.init.etshtinkerEffects;
import com.c2h6s.etshtinker.init.etshtinkerParticleType;
import com.hoshino.cti.Capabilitiess.IElectricShielding;
import com.hoshino.cti.Capabilitiess.IFreezeShielding;
import com.hoshino.cti.Capabilitiess.IPressureShielding;
import com.hoshino.cti.Capabilitiess.IScorchShielding;
import com.hoshino.cti.Capabilitiess.ctiCapabilities;
import com.hoshino.cti.Entity.specialDamageSource.Environmental;
import com.hoshino.cti.netwrok.ctiPacketHandler;
import com.hoshino.cti.netwrok.packet.PFrozenValueSync;
import com.hoshino.cti.netwrok.packet.PIonizeValueSync;
import com.hoshino.cti.netwrok.packet.PPressureValueSync;
import com.hoshino.cti.netwrok.packet.PScorchValueSync;
import com.hoshino.cti.util.BiomeUtil;
import com.hoshino.cti.util.ctiTagkey;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class EnvironmentSystem {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final float baseDmg = 10.0f;
    public static final float Multiplier = 0.1f;
    public static final String IONIZED_AMOUNT = "environmental.ionized";
    public static final String SCORCH_AMOUNT = "environmental.scorch";
    public static final String FROZEN_AMOUNT = "environmental.frozen";
    public static final String PRESSURE_AMOUNT = "environmental.pressure";

    public static void EnvironmentTick(LivingEntity living, ServerLevel level) {
        Player player;
        Holder biome = level.m_204166_(living.m_20183_());
        float lvl_ionize = BiomeUtil.getBiomeIonizeLevel((Holder<Biome>)biome) - EnvironmentSystem.getElectricResistance(living);
        float lvl_scorch = BiomeUtil.getBiomeScorchLevel((Holder<Biome>)biome) - EnvironmentSystem.getScorchResistance(living) - BiomeUtil.getBiomeFreezeLevel((Holder<Biome>)biome);
        float lvl_freeze = BiomeUtil.getBiomeFreezeLevel((Holder<Biome>)biome) - EnvironmentSystem.getFreezeResistance(living) - BiomeUtil.getBiomeScorchLevel((Holder<Biome>)biome);
        float lvl_pressure = BiomeUtil.getBiomePressureLevel((Holder<Biome>)biome) - EnvironmentSystem.getPressureResistance(living);
        if (living.m_21233_() > 5000.0f && !(living instanceof Player)) {
            lvl_ionize = -0.5f;
            lvl_scorch = -0.5f;
            lvl_freeze = -0.5f;
            lvl_pressure = -0.5f;
        }
        if ((double)lvl_pressure > 1.5) {
            living.f_19802_ = 0;
            if (living instanceof Player) {
                Player player2 = (Player)living;
                living.m_6469_((DamageSource)Environmental.playerPressureSource(Float.MAX_VALUE, (LivingEntity)player2), Float.MAX_VALUE);
            } else {
                living.m_6469_((DamageSource)Environmental.pressureSource(Float.MAX_VALUE), Float.MAX_VALUE);
            }
        }
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128350_(IONIZED_AMOUNT, Mth.m_14036_((float)(nbt.m_128457_(IONIZED_AMOUNT) + lvl_ionize), (float)(-20.0f * (1.0f + EnvironmentSystem.getElectricResistance(living))), (float)10000.0f));
        nbt.m_128350_(SCORCH_AMOUNT, Mth.m_14036_((float)(nbt.m_128457_(SCORCH_AMOUNT) + lvl_scorch), (float)(-40.0f * (1.0f + EnvironmentSystem.getScorchResistance(living))), (float)10000.0f));
        nbt.m_128350_(FROZEN_AMOUNT, Mth.m_14036_((float)(nbt.m_128457_(FROZEN_AMOUNT) + lvl_freeze), (float)(-60.0f * (1.0f + EnvironmentSystem.getScorchResistance(living))), (float)10000.0f));
        nbt.m_128350_(PRESSURE_AMOUNT, Mth.m_14036_((float)(nbt.m_128457_(PRESSURE_AMOUNT) + lvl_pressure), (float)(-100.0f * (1.0f + EnvironmentSystem.getPressureResistance(living))), (float)10000.0f));
        float ion_multiplier = (nbt.m_128457_(IONIZED_AMOUNT) - 50.0f) / 25.0f;
        float sco_multiplier = (nbt.m_128457_(SCORCH_AMOUNT) - 50.0f) / 75.0f - 0.25f;
        float fro_multiplier = (nbt.m_128457_(FROZEN_AMOUNT) - 50.0f) / 100.0f - 0.25f;
        float pre_multiplier = (nbt.m_128457_(PRESSURE_AMOUNT) - 50.0f) / 50.0f - 0.25f;
        if (ion_multiplier > 0.0f && living.m_6084_()) {
            living.f_19802_ = 0;
            if (living instanceof Player) {
                player = (Player)living;
                living.m_6469_((DamageSource)Environmental.playerIonizedSource(10.0f * ion_multiplier, (LivingEntity)player), 0.025f * living.m_21233_() * ion_multiplier);
            } else {
                living.m_6469_((DamageSource)Environmental.ionizedSource(10.0f * ion_multiplier), 0.025f * living.m_21233_() * ion_multiplier);
            }
            living.m_7292_(new MobEffectInstance((MobEffect)etshtinkerEffects.ionized.get(), 50, (int)ion_multiplier));
            ((ServerLevel)living.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)etshtinkerParticleType.electric.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(10.0f * fro_multiplier * 3.0f), 0.0, 0.0, 0.0, 0.25);
            nbt.m_128350_(IONIZED_AMOUNT, Math.max(0.0f, nbt.m_128457_(IONIZED_AMOUNT) * 0.99f));
        }
        if (sco_multiplier > 0.0f && living.m_6084_()) {
            living.f_19802_ = 0;
            if (living instanceof Player) {
                player = (Player)living;
                living.m_6469_((DamageSource)Environmental.playerScorchSource(10.0f * sco_multiplier, (LivingEntity)player), 10.0f * sco_multiplier);
            } else {
                living.m_6469_((DamageSource)Environmental.scorchSource(10.0f * sco_multiplier), 10.0f * sco_multiplier);
            }
            living.m_20254_(20);
            ((ServerLevel)living.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(10.0f * sco_multiplier * 3.0f), 0.0, 0.0, 0.0, 0.25);
            nbt.m_128350_(SCORCH_AMOUNT, Math.max(0.0f, nbt.m_128457_(SCORCH_AMOUNT) * 0.99f));
        }
        if (fro_multiplier > 0.0f && living.m_6084_()) {
            living.f_19802_ = 0;
            if (living instanceof Player) {
                player = (Player)living;
                living.m_6469_((DamageSource)Environmental.playerFrozenSource(10.0f * fro_multiplier, (LivingEntity)player), 5.0f * fro_multiplier);
            } else {
                living.m_6469_((DamageSource)Environmental.frozenSource(10.0f * fro_multiplier), 5.0f * fro_multiplier);
            }
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), 50, (int)fro_multiplier));
            ((ServerLevel)living.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(10.0f * fro_multiplier * 3.0f), 0.0, 0.0, 0.0, 0.25);
            nbt.m_128350_(FROZEN_AMOUNT, Math.max(0.0f, nbt.m_128457_(FROZEN_AMOUNT) * 0.99f));
        }
        if (pre_multiplier > 0.0f && living.m_6084_()) {
            living.f_19802_ = 0;
            if (living instanceof Player) {
                player = (Player)living;
                living.m_6469_((DamageSource)Environmental.playerPressureSource(0.1f * pre_multiplier * living.m_21233_(), (LivingEntity)player), 0.1f * pre_multiplier * living.m_21233_());
            } else {
                living.m_6469_((DamageSource)Environmental.pressureSource(0.1f * pre_multiplier * living.m_21233_()), 0.1f * pre_multiplier * living.m_21233_());
            }
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, (int)pre_multiplier * 2));
            ((ServerLevel)living.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(10.0f * pre_multiplier * 3.0f), 0.0, 0.0, 0.0, 0.25);
            nbt.m_128350_(PRESSURE_AMOUNT, Math.max(0.0f, nbt.m_128457_(PRESSURE_AMOUNT) * 0.99f));
        }
        if (living instanceof ServerPlayer) {
            player = (ServerPlayer)living;
            ctiPacketHandler.sendToPlayer(new PIonizeValueSync(nbt.m_128457_(IONIZED_AMOUNT), lvl_ionize), (ServerPlayer)player);
            ctiPacketHandler.sendToPlayer(new PScorchValueSync(nbt.m_128457_(SCORCH_AMOUNT), lvl_scorch), (ServerPlayer)player);
            ctiPacketHandler.sendToPlayer(new PFrozenValueSync(nbt.m_128457_(FROZEN_AMOUNT), lvl_freeze), (ServerPlayer)player);
            ctiPacketHandler.sendToPlayer(new PPressureValueSync(nbt.m_128457_(PRESSURE_AMOUNT), lvl_pressure), (ServerPlayer)player);
        }
    }

    public static void addScorchValue(@NotNull LivingEntity living, float amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128350_(SCORCH_AMOUNT, nbt.m_128457_(SCORCH_AMOUNT) + amount);
    }

    public static void addFrozenValue(@NotNull LivingEntity living, float amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128350_(FROZEN_AMOUNT, nbt.m_128457_(FROZEN_AMOUNT) + amount);
    }

    public static void addIonizedValue(@NotNull LivingEntity living, float amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128350_(IONIZED_AMOUNT, nbt.m_128457_(IONIZED_AMOUNT) + amount);
    }

    public static void addPressureValue(@NotNull LivingEntity living, float amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128350_(PRESSURE_AMOUNT, nbt.m_128457_(PRESSURE_AMOUNT) + amount);
    }

    public static float getScorchValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128457_(SCORCH_AMOUNT) - 50.0f;
    }

    public static float getFrozenValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128457_(FROZEN_AMOUNT) - 50.0f;
    }

    public static float getIonizedValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128457_(IONIZED_AMOUNT) - 50.0f;
    }

    public static float getPressureValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128457_(PRESSURE_AMOUNT) - 50.0f;
    }

    public static float allEnvironmentValue(@NotNull LivingEntity living) {
        return EnvironmentSystem.getPressureValue(living) + EnvironmentSystem.getFrozenValue(living) + EnvironmentSystem.getIonizedValue(living) + EnvironmentSystem.getScorchValue(living) - 200.0f;
    }

    public static float getElectricResistance(LivingEntity living) {
        float resist = 0.0f;
        if (!(living instanceof Player)) {
            resist += 1.0f;
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentSystem.getCapability((ICapabilityProvider)stack, ctiCapabilities.ELECTRIC_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IElectricShielding)shielding.get()).getElectricShieldinng();
                continue;
            }
            if (!stack.m_204131_().toList().contains(ctiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getScorchResistance(LivingEntity living) {
        float resist = 0.0f;
        if (!(living instanceof Player)) {
            resist += 1.0f;
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentSystem.getCapability((ICapabilityProvider)stack, ctiCapabilities.SCORCH_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IScorchShielding)shielding.get()).getScorchShieldinng();
                continue;
            }
            if (!stack.m_204131_().toList().contains(ctiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getFreezeResistance(LivingEntity living) {
        float resist = 0.0f;
        if (!(living instanceof Player)) {
            resist += 1.0f;
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentSystem.getCapability((ICapabilityProvider)stack, ctiCapabilities.FREEZE_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IFreezeShielding)shielding.get()).getFreezeShieldinng();
                continue;
            }
            if (stack.m_204131_().toList().contains(ctiTagkey.PRESSURE_MINOR)) {
                resist += 0.5f;
                continue;
            }
            if (!stack.m_204131_().toList().contains(ctiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getPressureResistance(LivingEntity living) {
        float resist = 0.0f;
        if (!(living instanceof Player)) {
            resist += 1.0f;
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentSystem.getCapability((ICapabilityProvider)stack, ctiCapabilities.PRESSURE_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IPressureShielding)shielding.get()).getPressureShielding();
                continue;
            }
            if (stack.m_204131_().toList().contains(ctiTagkey.PRESSURE_MINOR)) {
                resist += 0.5f;
                continue;
            }
            if (!stack.m_204131_().toList().contains(ctiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    @NotNull
    public static <T> LazyOptional<T> getCapability(@Nullable ICapabilityProvider provider, @Nullable Capability<T> cap, @Nullable Direction side) {
        if (provider == null || cap == null || !cap.isRegistered()) {
            return LazyOptional.empty();
        }
        return provider.getCapability(cap, side);
    }
}

