/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity;

import com.c2h6s.etshtinker.etshtinker;
import com.hoshino.cti.Blocks.BlockEntity.GeneralMachineEntity;
import com.hoshino.cti.Blocks.Machine.ReactorNeutronCollectorBlock;
import com.hoshino.cti.Screen.menu.ReactorNeutronCollectorMenu;
import com.hoshino.cti.netwrok.ctiPacketHandler;
import com.hoshino.cti.netwrok.packet.PMachineEnergySync;
import com.hoshino.cti.recipe.ReactorNeutronCollectorRecipe;
import com.hoshino.cti.recipe.RecipeMap;
import com.hoshino.cti.register.ctiBlock;
import com.hoshino.cti.register.ctiBlockEntityType;
import com.hoshino.cti.util.EmptyHandlers;
import com.hoshino.cti.util.ctiEnergyStore;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismGases;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorNeutronCollectorEntity
extends GeneralMachineEntity
implements MenuProvider {
    public ContainerData DATA;
    public int PROGRESS = 0;
    public int MAX_PROGRESS = 100000000;
    protected Component DISPLAY_NAME = Component.m_237115_((String)"cti.machine.reactor_neutron_collector").m_130940_(ChatFormatting.DARK_PURPLE);
    protected int MAX_ENERGY = 500000000;
    protected int MAX_TRANSFER = 500000000;
    protected int BASE_ENERGY_PERTICK = 25000000;
    protected int BASE_SODIUM = 100000000;
    protected int BASE_SODIUM_PERTICK = 100000;
    public int CurrentEnergy = 0;
    public final ctiEnergyStore ENERGY_STORAGE = new ctiEnergyStore(this.getMaxEnergy(), this.getMaxTransfer()){

        @Override
        public void onEnergyChange() {
            ReactorNeutronCollectorEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ReactorNeutronCollectorEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };
    private final IGasHandler gasHandler = new IGasHandler(){

        public int getTanks() {
            return 0;
        }

        public GasStack getChemicalInTank(int i) {
            return GasStack.EMPTY;
        }

        public void setChemicalInTank(int i, GasStack stack) {
        }

        public long getTankCapacity(int i) {
            return 0L;
        }

        public boolean isValid(int i, GasStack stack) {
            return false;
        }

        public GasStack insertChemical(int i, GasStack stack, Action action) {
            return GasStack.EMPTY;
        }

        public GasStack extractChemical(int i, long l, Action action) {
            return GasStack.EMPTY;
        }
    };
    private LazyOptional<ItemStackHandler> LazyitemStackHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> LazyenergyHandler = LazyOptional.empty();
    private LazyOptional<IGasHandler> LazyGasHandler = LazyOptional.empty();

    public ReactorNeutronCollectorEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ctiBlockEntityType.REACTOR_NEUTRON_COLLECTOR.get(), blockPos, blockState);
        this.DATA = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ReactorNeutronCollectorEntity.this.PROGRESS;
                    case 1 -> ReactorNeutronCollectorEntity.this.MAX_PROGRESS;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ReactorNeutronCollectorEntity.this.PROGRESS = value;
                        break;
                    }
                    case 1: {
                        ReactorNeutronCollectorEntity.this.MAX_PROGRESS = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public int getMaxEnergy() {
        return this.MAX_ENERGY;
    }

    public int getMaxTransfer() {
        return this.MAX_TRANSFER;
    }

    public int getMaxProgress() {
        return this.MAX_PROGRESS;
    }

    public int getEnergyPerTick() {
        return this.BASE_ENERGY_PERTICK;
    }

    public Component m_5446_() {
        return this.DISPLAY_NAME;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyitemStackHandler.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.LazyenergyHandler.cast();
        }
        Direction locDir = (Direction)this.m_58900_().m_61143_((Property)ReactorNeutronCollectorBlock.FACING);
        if (capability == Capabilities.GAS_HANDLER && (direction == locDir.m_122427_() || direction == locDir.m_122428_())) {
            return this.LazyGasHandler.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyitemStackHandler = LazyOptional.of(() -> this.itemStackHandler);
        this.LazyenergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.LazyGasHandler = LazyOptional.of(() -> this.gasHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyitemStackHandler.invalidate();
        this.LazyenergyHandler.invalidate();
        this.LazyGasHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        nbt.m_128365_("energy_store", this.ENERGY_STORAGE.serializeNBT());
        nbt.m_128405_("reactor_neutron_collector.progress", this.PROGRESS);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.ENERGY_STORAGE.deserializeNBT(nbt.m_128423_("energy_store"));
        this.PROGRESS = nbt.m_128451_("reactor_neutron_collector.progress");
        super.m_142466_(nbt);
    }

    public void dropItem() {
        if (this.itemStackHandler.getSlots() > 0) {
            SimpleContainer container = new SimpleContainer(this.itemStackHandler.getSlots());
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                container.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
            }
            if (this.f_58857_ != null) {
                Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
            }
        }
    }

    @Nullable
    public ctiEnergyStore getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ReactorNeutronCollectorEntity entity) {
        GasStack gasStack;
        GasStack stack;
        int a;
        if (level.f_46443_) {
            return;
        }
        ctiPacketHandler.sendToClient(new PMachineEnergySync(entity.ENERGY_STORAGE.getEnergyStored(), entity.m_58899_()));
        if (!state.m_60713_((Block)ctiBlock.reactor_neutron_collector.get())) {
            return;
        }
        for (Direction direction : List.of(Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH)) {
            int amount;
            IEnergyStorage storage;
            if (entity.ENERGY_STORAGE.getEnergyStored() <= 0) break;
            BlockEntity energyContainer = level.m_7702_(entity.m_58899_().m_121945_(direction));
            if (energyContainer == null || !energyContainer.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent() || (storage = (IEnergyStorage)energyContainer.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)).receiveEnergy(amount = Math.min(storage.receiveEnergy(entity.ENERGY_STORAGE.getEnergyStored(), true), entity.ENERGY_STORAGE.extractEnergy(entity.ENERGY_STORAGE.getEnergyStored(), true)), true) != amount) continue;
            storage.receiveEnergy(amount, false);
            entity.ENERGY_STORAGE.extractEnergy(amount, false);
        }
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockEntity inputContainer = level.m_7702_(blockPos.m_121945_(direction.m_122427_()));
        BlockEntity outputContainer = level.m_7702_(blockPos.m_121945_(direction.m_122428_()));
        BlockEntity itemContainer = level.m_7702_(blockPos.m_7494_());
        if (itemContainer == null || outputContainer == null || inputContainer == null) {
            return;
        }
        LazyOptional inputOptional = inputContainer.getCapability(Capabilities.GAS_HANDLER, direction.m_122428_());
        LazyOptional outputOptional = outputContainer.getCapability(Capabilities.GAS_HANDLER, direction.m_122427_());
        LazyOptional itemOptional = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        IGasHandler inputHandler = (IGasHandler)inputOptional.orElse((Object)EmptyHandlers.GAS_EMPTY);
        IGasHandler outputHandler = (IGasHandler)outputOptional.orElse((Object)EmptyHandlers.GAS_EMPTY);
        IItemHandler itemHandler = (IItemHandler)itemOptional.orElse((Object)EmptyHandlers.ITEM_EMPTY);
        if (inputHandler.equals(EmptyHandlers.GAS_EMPTY) || outputHandler.equals(EmptyHandlers.GAS_EMPTY) || itemHandler.equals(EmptyHandlers.ITEM_EMPTY)) {
            return;
        }
        Gas heatedSodium = (Gas)MekanismGases.SUPERHEATED_SODIUM.get();
        Gas sodium = (Gas)MekanismGases.SODIUM.get();
        boolean canInput = false;
        boolean canOutput = false;
        boolean canOutputItem = false;
        float SodiumAmplifier = 1.0f;
        float chanceConsume = 0.0f;
        ItemStack catalyst = entity.itemStackHandler.getStackInSlot(0);
        ReactorNeutronCollectorRecipe recipe = ReactorNeutronCollectorEntity.getRecipe(level, catalyst);
        ItemStack output = new ItemStack((ItemLike)ModItems.neutron_nugget.get());
        if (recipe != null) {
            SodiumAmplifier += recipe.getEfficiency() * (float)(catalyst.m_41613_() / recipe.getCatalyst().m_41613_());
            chanceConsume = recipe.getConsumptionRate() * (float)(catalyst.m_41613_() / recipe.getCatalyst().m_41613_());
            output = recipe.m_8043_();
        }
        GasStack drain = GasStack.EMPTY;
        GasStack insert = GasStack.EMPTY;
        for (a = 0; a < inputHandler.getTanks(); ++a) {
            stack = (GasStack)inputHandler.getChemicalInTank(a);
            if (stack.getType() != heatedSodium) continue;
            drain = new GasStack((IGasProvider)heatedSodium, (long)Math.min((float)entity.BASE_SODIUM_PERTICK * SodiumAmplifier, (float)stack.getAmount()));
            gasStack = (GasStack)inputHandler.extractChemical((ChemicalStack)drain, Action.SIMULATE);
            if (gasStack.getAmount() > 0L) {
                drain = gasStack;
                canInput = true;
                break;
            }
            drain = GasStack.EMPTY;
        }
        for (a = 0; a < outputHandler.getTanks() && !drain.isEmpty(); ++a) {
            stack = (GasStack)outputHandler.getChemicalInTank(a);
            if (stack.getType() != sodium && !stack.isEmpty()) continue;
            insert = new GasStack((IGasProvider)sodium, Math.min(drain.getAmount(), outputHandler.getTankCapacity(a) - stack.getAmount()));
            gasStack = (GasStack)inputHandler.insertChemical((ChemicalStack)insert, Action.SIMULATE);
            if (gasStack.getAmount() > 0L) {
                insert = gasStack;
                canOutput = true;
                break;
            }
            insert = GasStack.EMPTY;
        }
        if (!canInput || !canOutput) {
            return;
        }
        long amount = Math.min(drain.getAmount(), insert.getAmount());
        drain.setAmount(amount);
        insert.setAmount(amount);
        inputHandler.extractChemical((ChemicalStack)drain, Action.EXECUTE);
        outputHandler.insertChemical((ChemicalStack)insert, Action.EXECUTE);
        if (entity.PROGRESS < 2000000000) {
            if (etshtinker.EtSHrnd().nextFloat() <= chanceConsume) {
                entity.itemStackHandler.extractItem(0, 1, false);
            }
            entity.PROGRESS = (int)Math.min(Integer.MAX_VALUE, (long)entity.PROGRESS + amount);
            entity.ENERGY_STORAGE.receiveEnergy(entity.getEnergyPerTick(), false);
            entity.m_6596_();
        }
        if (entity.PROGRESS >= entity.MAX_PROGRESS) {
            for (int a2 = 0; a2 < itemHandler.getSlots(); ++a2) {
                if (itemHandler.getStackInSlot(a2).m_41619_() && itemHandler.isItemValid(a2, output)) {
                    while (entity.PROGRESS >= entity.MAX_PROGRESS && itemHandler.getStackInSlot(a2).m_41613_() < itemHandler.getSlotLimit(a2) && itemHandler.isItemValid(a2, output)) {
                        itemHandler.insertItem(a2, output, false);
                        entity.PROGRESS -= entity.MAX_PROGRESS;
                    }
                } else {
                    if (!itemHandler.getStackInSlot(a2).m_150930_(output.m_41720_()) || itemHandler.getStackInSlot(a2).m_41613_() >= itemHandler.getSlotLimit(a2)) continue;
                    while (entity.PROGRESS >= entity.MAX_PROGRESS && itemHandler.getStackInSlot(a2).m_41613_() < itemHandler.getSlotLimit(a2) && itemHandler.isItemValid(a2, output)) {
                        itemHandler.insertItem(a2, output, false);
                        entity.PROGRESS -= entity.MAX_PROGRESS;
                    }
                }
                break;
            }
        }
    }

    public static ReactorNeutronCollectorRecipe getRecipe(Level level, ItemStack stack) {
        List<ReactorNeutronCollectorRecipe> list = List.copyOf(RecipeMap.NeutronRecipeList);
        for (ReactorNeutronCollectorRecipe recipe : list) {
            if (!recipe.getCatalyst().m_150930_(stack.m_41720_())) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        ctiPacketHandler.sendToClient(new PMachineEnergySync(this.ENERGY_STORAGE.getEnergyStored(), this.m_58899_()));
        return new ReactorNeutronCollectorMenu(i, inventory, this, this.DATA);
    }
}

