/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity;

import com.c2h6s.etshtinker.etshtinker;
import com.hoshino.cti.recipe.QuantumMinerRecipe;
import com.hoshino.cti.recipe.RecipeMap;
import com.hoshino.cti.register.ctiBlockEntityType;
import com.hoshino.cti.register.ctiItem;
import com.hoshino.cti.util.ctiEnergyStore;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuantumMinerEntity
extends BlockEntity {
    protected int MAX_ENERGY = Integer.MAX_VALUE;
    protected int MAX_TRANSFER = Integer.MAX_VALUE;
    protected int BASE_ENERGY_PERTICK = 0x8000000;
    private static final IItemHandler EMPTY = new IItemHandler(){

        public int getSlots() {
            return 0;
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return null;
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
            return null;
        }

        @NotNull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return null;
        }

        public int getSlotLimit(int i) {
            return 0;
        }

        public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
            return false;
        }
    };
    public final ctiEnergyStore ENERGY_STORAGE = new ctiEnergyStore(this.getMaxEnergy(), this.getMaxTransfer()){

        @Override
        public void onEnergyChange() {
            QuantumMinerEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            QuantumMinerEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_().equals(ctiItem.compressed_singularity.get());
        }
    };
    private LazyOptional<ItemStackHandler> LazyitemStackHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> LazyenergyHandler = LazyOptional.empty();

    public QuantumMinerEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ctiBlockEntityType.QUANTUM_MINER_ENTITY.get(), p_155229_, p_155230_);
    }

    public int getMaxEnergy() {
        return this.MAX_ENERGY;
    }

    public int getMaxTransfer() {
        return this.MAX_TRANSFER;
    }

    public int getEnergyPerTick() {
        return this.BASE_ENERGY_PERTICK;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyitemStackHandler.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.LazyenergyHandler.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyitemStackHandler = LazyOptional.of(() -> this.itemStackHandler);
        this.LazyenergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyitemStackHandler.invalidate();
        this.LazyenergyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        nbt.m_128365_("energy_store", this.ENERGY_STORAGE.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.ENERGY_STORAGE.deserializeNBT(nbt.m_128423_("energy_store"));
        super.m_142466_(nbt);
    }

    public void dropItem() {
        if (this.itemStackHandler.getSlots() > 0) {
            SimpleContainer container = new SimpleContainer(this.itemStackHandler.getSlots());
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                container.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
            }
            if (this.f_58857_ != null) {
                Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
            }
        }
    }

    @Nullable
    public ctiEnergyStore getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, QuantumMinerEntity entity) {
        LazyOptional optional;
        IItemHandler Handler;
        if (level.f_46443_) {
            return;
        }
        if (entity.itemStackHandler.getStackInSlot(0).m_41619_() || entity.itemStackHandler.getStackInSlot(0).m_41613_() == 0) {
            return;
        }
        if (entity.itemStackHandler.getStackInSlot(0).m_41720_() != ctiItem.compressed_singularity.get()) {
            return;
        }
        ItemStack output = QuantumMinerEntity.getOutPut(level);
        if (output.m_41619_()) {
            return;
        }
        if (entity.ENERGY_STORAGE.getEnergyStored() < entity.BASE_ENERGY_PERTICK) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos.m_7494_());
        if (blockEntity != null && (Handler = (IItemHandler)(optional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER)).orElse((Object)EMPTY)) != EMPTY) {
            int slotAmount = Handler.getSlots();
            boolean checkoutput = false;
            int effectiveSlot = 0;
            for (int a = 0; a < slotAmount; ++a) {
                if (!Handler.getStackInSlot(a).m_41619_() && (!Handler.getStackInSlot(a).m_150930_(output.m_41720_()) || Handler.getStackInSlot(a).m_41613_() + output.m_41613_() > Handler.getSlotLimit(a)) || !Handler.isItemValid(a, output)) continue;
                checkoutput = true;
                effectiveSlot = a;
            }
            if (!checkoutput) {
                return;
            }
            Handler.insertItem(effectiveSlot, output, false);
            entity.ENERGY_STORAGE.extractEnergy(entity.BASE_ENERGY_PERTICK, false);
            entity.itemStackHandler.extractItem(0, 1, false);
            entity.m_6596_();
        }
    }

    public static ItemStack getOutPut(Level level) {
        List<QuantumMinerRecipe> list = List.copyOf(RecipeMap.MinerRecipeList);
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int length = list.size();
        QuantumMinerRecipe recipe = list.get(etshtinker.EtSHrnd().nextInt(length));
        ItemStack stack = recipe.m_8043_();
        int count = (int)recipe.getChance();
        if (count == 0 && etshtinker.EtSHrnd().nextFloat() < recipe.getChance()) {
            stack = ItemStack.f_41583_;
        } else {
            float chance = recipe.getChance() - (float)count;
            stack.m_41764_(stack.m_41613_() + (count += etshtinker.EtSHrnd().nextFloat() < chance ? -1 : 0));
        }
        return stack;
    }
}

