/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity;

import com.hoshino.cti.Blocks.BlockEntity.GeneralMachineEntity;
import com.hoshino.cti.Blocks.BlockEntity.WrappedHandler;
import com.hoshino.cti.Blocks.Machine.AtmosphereExtractorBlock;
import com.hoshino.cti.Items.AtmosphereUpgradeItem;
import com.hoshino.cti.Screen.menu.AtmosphereExtractorMenu;
import com.hoshino.cti.netwrok.ctiPacketHandler;
import com.hoshino.cti.netwrok.packet.PMachineEnergySync;
import com.hoshino.cti.recipe.AtmosphereExtractorRecipe;
import com.hoshino.cti.recipe.RecipeMap;
import com.hoshino.cti.register.ctiBlockEntityType;
import com.hoshino.cti.util.BiomeUtil;
import com.hoshino.cti.util.ctiEnergyStore;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtmosphereExtractorEntity
extends GeneralMachineEntity
implements MenuProvider {
    public ContainerData DATA;
    public int PROGRESS = 0;
    public int MAX_PROGRESS = 100;
    protected Component DISPLAY_NAME = Component.m_237115_((String)"cti.machine.atmosphere_extractor").m_130940_(ChatFormatting.DARK_PURPLE);
    protected int MAX_ENERGY = 75000000;
    protected int MAX_TRANSFER = 75000000;
    protected int BASE_ENERGY_PERTICK = 750000;
    public int CurrentEnergy = 0;
    public final ctiEnergyStore ENERGY_STORAGE = new ctiEnergyStore(this.getMaxEnergy(), this.getMaxTransfer()){

        @Override
        public void onEnergyChange() {
            AtmosphereExtractorEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            AtmosphereExtractorEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 4) {
                return !stack.m_41619_() && stack.m_41720_() instanceof AtmosphereUpgradeItem;
            }
            return false;
        }
    };
    private LazyOptional<ItemStackHandler> LazyitemStackHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> LazyenergyHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemStackHandler, i -> i == 4, (i, s) -> false)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemStackHandler, i -> i == 4, (i, s) -> false)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemStackHandler, i -> i == 4, (i, s) -> false)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemStackHandler, i -> i == 4, (i, s) -> false)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemStackHandler, i -> i == 4, (i, s) -> false)));

    public AtmosphereExtractorEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ctiBlockEntityType.Atmosphere_extractor.get(), blockPos, blockState);
        this.DATA = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> AtmosphereExtractorEntity.this.PROGRESS;
                    case 1 -> AtmosphereExtractorEntity.this.MAX_PROGRESS;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        AtmosphereExtractorEntity.this.PROGRESS = value;
                        break;
                    }
                    case 1: {
                        AtmosphereExtractorEntity.this.MAX_PROGRESS = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public int getMaxEnergy() {
        return this.MAX_ENERGY;
    }

    public int getMaxTransfer() {
        return this.MAX_TRANSFER;
    }

    public int getMaxProgress() {
        return this.MAX_PROGRESS;
    }

    public int getEnergyPerTick() {
        return (int)((float)this.BASE_ENERGY_PERTICK * AtmosphereExtractorEntity.getPowerFactor(this));
    }

    public Component m_5446_() {
        return this.DISPLAY_NAME;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (direction == null) {
                return this.LazyitemStackHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(direction)) {
                Direction locDir = (Direction)this.m_58900_().m_61143_((Property)AtmosphereExtractorBlock.FACING);
                if (direction == Direction.UP || direction == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(direction).cast();
                }
                return switch (locDir) {
                    default -> this.directionWrappedHandlerMap.get(direction.m_122424_()).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(direction.m_122428_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(direction.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(direction).cast();
                };
            }
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.LazyenergyHandler.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyitemStackHandler = LazyOptional.of(() -> this.itemStackHandler);
        this.LazyenergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyitemStackHandler.invalidate();
        this.LazyenergyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        nbt.m_128365_("energy_store", this.ENERGY_STORAGE.serializeNBT());
        nbt.m_128405_("atmosphere_extractor.progress", this.PROGRESS);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.ENERGY_STORAGE.deserializeNBT(nbt.m_128423_("energy_store"));
        this.PROGRESS = nbt.m_128451_("atmosphere_extractor.progress");
        super.m_142466_(nbt);
    }

    public void dropItem() {
        if (this.itemStackHandler.getSlots() > 0) {
            SimpleContainer container = new SimpleContainer(this.itemStackHandler.getSlots());
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                container.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
            }
            if (this.f_58857_ != null) {
                Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
            }
        }
    }

    @Nullable
    public ctiEnergyStore getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static float getPowerFactor(AtmosphereExtractorEntity entity) {
        float factor = 1.0f;
        ItemStackHandler handler = entity.itemStackHandler;
        if (handler != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof AtmosphereUpgradeItem)) continue;
                AtmosphereUpgradeItem item2 = (AtmosphereUpgradeItem)item;
                factor *= item2.POWER_FACTOR;
            }
        }
        return factor;
    }

    public static float getSpeedFactor(AtmosphereExtractorEntity entity) {
        float factor = 1.0f;
        ItemStackHandler handler = entity.itemStackHandler;
        if (handler != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof AtmosphereUpgradeItem)) continue;
                AtmosphereUpgradeItem item2 = (AtmosphereUpgradeItem)item;
                factor += item2.SPEED_FACTOR;
            }
        }
        return factor;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AtmosphereExtractorEntity entity) {
        BlockState blockstate;
        if (level.f_46443_) {
            return;
        }
        ctiPacketHandler.sendToClient(new PMachineEnergySync(entity.ENERGY_STORAGE.getEnergyStored(), entity.m_58899_()));
        ResourceKey<Biome> biomekey = BiomeUtil.getBiomeKey((Holder<Biome>)level.m_204166_(blockPos));
        if (biomekey == null) {
            return;
        }
        if (entity.ENERGY_STORAGE.getEnergyStored() <= entity.getEnergyPerTick()) {
            return;
        }
        ItemStack output = AtmosphereExtractorEntity.getOutPut(biomekey, level);
        if (output.m_41619_()) {
            return;
        }
        if (!AtmosphereExtractorEntity.canOutput(entity, output)) {
            return;
        }
        int Speed = 1;
        BlockPos pos = blockPos;
        for (int i = 0; i < 4 && ((blockstate = level.m_8055_(pos = pos.m_7494_())).m_60713_(Blocks.f_50016_) || blockstate.m_60713_(Blocks.f_50627_) || blockstate.m_60713_(Blocks.f_50626_)); ++i) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123776_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1, 0.25, 0.25, 0.25, 0.05);
            ++Speed;
        }
        Speed = (int)((float)Speed * AtmosphereExtractorEntity.getSpeedFactor(entity));
        entity.PROGRESS = Mth.m_14045_((int)(entity.PROGRESS + Speed), (int)0, (int)entity.MAX_PROGRESS);
        entity.ENERGY_STORAGE.extractEnergy(entity.getEnergyPerTick(), false);
        if (entity.PROGRESS == entity.MAX_PROGRESS) {
            entity.PROGRESS = 0;
            AtmosphereExtractorEntity.Output(entity, output);
            AtmosphereExtractorEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    public static ItemStack getOutPut(ResourceKey<Biome> biomekey, Level level) {
        List<AtmosphereExtractorRecipe> recipeList = List.copyOf(RecipeMap.ExtractorRecipeList);
        for (AtmosphereExtractorRecipe recipe : recipeList) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(recipe.getBiome()));
            if (!key.equals(biomekey)) continue;
            return recipe.m_8043_();
        }
        return ItemStack.f_41583_;
    }

    public static boolean canOutput(AtmosphereExtractorEntity entity, ItemStack stack) {
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, entity.itemStackHandler.getStackInSlot(4));
        return container.m_7983_() || container.m_8020_(0).m_150930_(stack.m_41720_()) && container.m_8020_(0).m_41613_() + stack.m_41613_() <= 64;
    }

    public static void Output(AtmosphereExtractorEntity entity, ItemStack output) {
        ItemStack stack = entity.itemStackHandler.getStackInSlot(4);
        ItemStack outputStack = new ItemStack((ItemLike)output.m_41720_(), output.m_41613_() + stack.m_41613_());
        entity.itemStackHandler.setStackInSlot(4, outputStack);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        ctiPacketHandler.sendToClient(new PMachineEnergySync(this.ENERGY_STORAGE.getEnergyStored(), this.m_58899_()));
        return new AtmosphereExtractorMenu(i, inventory, this, this.DATA);
    }
}

