/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity;

import com.hoshino.cti.register.ctiBlockEntityType;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.multiblock.ServantTileEntity;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;

public class AlloyCentrifugeEntity
extends BlockEntity {
    protected static List<AlloyRecipe> list = new ArrayList<AlloyRecipe>();
    private LazyOptional<IAirHandlerMachine> airHandler = LazyOptional.empty();
    private MachineAirHandler machineAirHandler = new MachineAirHandler(PressureTier.TIER_TWO, 12800){

        public float getCriticalPressure() {
            return 40.0f;
        }

        @Nullable
        public Direction getSideLeaking() {
            return null;
        }

        public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
            return super.getConnectedAirHandlers(ownerTE);
        }
    };

    public AlloyCentrifugeEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ctiBlockEntityType.ALLOY_CENTRIFUGE.get(), p_155229_, p_155230_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            return this.airHandler.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void onLoad() {
        this.airHandler = LazyOptional.of(() -> this.machineAirHandler);
        super.onLoad();
    }

    public void invalidateCaps() {
        this.airHandler.invalidate();
        super.invalidateCaps();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("AirHandler", (Tag)this.machineAirHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.machineAirHandler.deserializeNBT(nbt.m_128469_("AirHandler"));
        if (nbt.m_128441_("AirAmount")) {
            this.machineAirHandler.addAir(nbt.m_128451_("AirAmount"));
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AlloyCentrifugeEntity entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity.machineAirHandler.getVolume() < 100 * (int)entity.machineAirHandler.getPressure() || entity.machineAirHandler.getPressure() < 7.0f) {
            return;
        }
        if (level.m_46467_() % (long)Math.max(3, 18 - (int)entity.machineAirHandler.getPressure()) != 0L) {
            return;
        }
        if (list.isEmpty()) {
            list = level.m_7465_().m_44013_((RecipeType)TinkerRecipeTypes.ALLOYING.get());
        }
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockEntity blockEntity = level.m_7702_(entity.m_58899_().m_121945_(direction.m_122424_()));
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof ServantTileEntity) {
            BlockEntity master;
            ServantTileEntity servantTileEntity = (ServantTileEntity)blockEntity;
            BlockEntity blockEntity2 = master = servantTileEntity.getMasterPos() != null ? level.m_7702_(servantTileEntity.getMasterPos()) : null;
            if (master instanceof ISmelteryTankHandler) {
                ISmelteryTankHandler smelteryTankHandler = (ISmelteryTankHandler)master;
                ArrayList OutputfluidStacks = new ArrayList();
                SmelteryTank smelteryTank = smelteryTankHandler.getTank();
                for (int i = 0; i < smelteryTank.getTanks(); ++i) {
                    boolean canDrain;
                    FluidStack stack = smelteryTank.getFluidInTank(i);
                    AlloyRecipe recipe = AlloyCentrifugeEntity.getRecipe(stack);
                    FluidStack InputFluid = FluidStack.EMPTY;
                    if (recipe != null && recipe.getOutput().getAmount() <= stack.getAmount()) {
                        InputFluid = recipe.getOutput();
                        List listList = recipe.getDisplayInputs();
                        for (List ls : listList) {
                            OutputfluidStacks.addAll(ls);
                        }
                    }
                    boolean canFill = false;
                    for (FluidStack fluidStack : OutputfluidStacks) {
                        int amount = smelteryTank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                        if (amount == fluidStack.getAmount()) {
                            canFill = true;
                            continue;
                        }
                        canFill = false;
                        break;
                    }
                    boolean bl = canDrain = smelteryTank.drain(InputFluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == InputFluid.getAmount() && !InputFluid.isEmpty();
                    if (!canFill || !canDrain) continue;
                    entity.machineAirHandler.addAir(-100 * (int)entity.machineAirHandler.getPressure());
                    smelteryTank.drain(InputFluid, IFluidHandler.FluidAction.EXECUTE);
                    for (FluidStack fluidStack : OutputfluidStacks) {
                        smelteryTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return;
                }
            }
        }
    }

    public static AlloyRecipe getRecipe(FluidStack fluidStack) {
        AlloyRecipe recipe = null;
        if (list.isEmpty()) {
            return recipe;
        }
        for (AlloyRecipe recipes : list) {
            if (!recipes.getOutput().getFluid().m_6212_(fluidStack.getFluid())) continue;
            recipe = recipes;
            break;
        }
        return recipe;
    }
}

