/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.structure;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.datagen.IafBiomeTagGenerator;
import com.github.alexthe666.iceandfire.datagen.IafStructurePieces;
import com.github.alexthe666.iceandfire.world.IafStructureTypes;
import com.github.alexthe666.iceandfire.world.structure.IafStructure;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class GraveyardStructure
extends IafStructure {
    public static final Codec<GraveyardStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GraveyardStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, GraveyardStructure::new)).codec();

    public GraveyardStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext pContext) {
        if (!IafConfig.generateGraveyards) {
            return Optional.empty();
        }
        BlockPos blockpos = pContext.f_226628_().m_151394_(1);
        if (!this.isBiomeValid(pContext, BiomeConfig.graveyardBiomes, blockpos)) {
            return Optional.empty();
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)pContext, (Holder)this.startPool, (Optional)this.startJigsawName, (int)this.size, (BlockPos)blockpos, (boolean)false, (Optional)this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    @Override
    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.GRAVEYARD.get();
    }

    public static GraveyardStructure buildStructureConfig(RegistryOps<JsonElement> registryOps) {
        Holder startPool = ((Registry)registryOps.m_206826_(Registry.f_122884_).get()).m_214121_(IafStructurePieces.GRAVEYARD_START);
        return new GraveyardStructure(new Structure.StructureSettings((HolderSet)((Registry)registryOps.m_206826_(Registry.f_122885_).get()).m_203561_(IafBiomeTagGenerator.HAS_GRAVEYARD), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)startPool, Optional.empty(), 1, (HeightProvider)ConstantHeight.f_161945_, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 16);
    }
}

