/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ChainProperties {
    private static final String CHAIN_TO_TAG = "ChainOwnerIaf";
    private static final String CHAIN_TO_ENTITY_ID_TAG = "ChainOwnerIDIaf";
    private static final String CHAIN_DATA = "ChainDataIaf";
    private static HashMap<CompoundTag, Boolean> containsChainData = new HashMap();

    public static void attachChain(LivingEntity chained, Entity chainedTo) {
        if (ChainProperties.isChainedTo(chained, chainedTo)) {
            return;
        }
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)chained);
        ListTag chainData = ChainProperties.getOrCreateChainData(entityData);
        CompoundTag currentChainData = new CompoundTag();
        currentChainData.m_128362_(CHAIN_TO_TAG, chainedTo.m_20148_());
        currentChainData.m_128405_(CHAIN_TO_ENTITY_ID_TAG, chainedTo.m_19879_());
        chainData.add((Object)currentChainData);
        entityData.m_128365_(CHAIN_DATA, (Tag)chainData);
        ChainProperties.updateData(chained, entityData);
    }

    public static CompoundTag getConnectedEntityChainData(LivingEntity host, Entity target) {
        ListTag chainData = ChainProperties.getOrCreateChainData(host);
        if (chainData.isEmpty()) {
            return null;
        }
        return ChainProperties.getConnectedEntityChainData(chainData, target);
    }

    @Nullable
    public static CompoundTag getConnectedEntityChainData(ListTag chainData, Entity entity) {
        for (int i = 0; i < chainData.size(); ++i) {
            CompoundTag nbt = (CompoundTag)chainData.get(i);
            if (!nbt.m_128441_(CHAIN_TO_TAG) || !nbt.m_128342_(CHAIN_TO_TAG).equals(entity.m_20148_())) continue;
            return nbt;
        }
        return null;
    }

    public static boolean hasChainData(LivingEntity entity) {
        return !ChainProperties.getOrCreateChainData(entity).isEmpty();
    }

    public static boolean hasEntityData(ListTag chainData, Entity entity) {
        return ChainProperties.getConnectedEntityChainData(chainData, entity) != null;
    }

    private static ListTag getOrCreateChainData(LivingEntity entity) {
        return ChainProperties.getOrCreateChainData(CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity));
    }

    private static ListTag getOrCreateChainData(CompoundTag entityData) {
        if (containsChainData.containsKey(entityData) && containsChainData.get(entityData).booleanValue() && entityData.m_128425_(CHAIN_DATA, 9)) {
            return entityData.m_128437_(CHAIN_DATA, 10);
        }
        if (entityData.m_128425_(CHAIN_DATA, 9)) {
            containsChainData.put(entityData, true);
            return entityData.m_128437_(CHAIN_DATA, 10);
        }
        containsChainData.put(entityData, false);
        return new ListTag();
    }

    public static void updateData(LivingEntity entity) {
        ChainProperties.updateData(entity, CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundTag nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
        if (!entity.f_19853_.m_5776_()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.m_19879_()));
        }
    }

    public static void removeChain(LivingEntity entity, Entity connectedTo) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        ListTag chainData = ChainProperties.getOrCreateChainData(entityData);
        int dataIndex = -1;
        for (int i = 0; i < chainData.size(); ++i) {
            CompoundTag nbt = (CompoundTag)chainData.get(i);
            if (!nbt.m_128441_(CHAIN_TO_TAG) || !nbt.m_128342_(CHAIN_TO_TAG).equals(connectedTo.m_20148_())) continue;
            dataIndex = i;
            break;
        }
        if (dataIndex != -1) {
            chainData.remove(dataIndex);
            entityData.m_128365_(CHAIN_DATA, (Tag)chainData);
            ChainProperties.updateData(entity, entityData);
        }
    }

    public static List<Entity> getChainedTo(LivingEntity chained) {
        ListTag chainData = ChainProperties.getOrCreateChainData(chained);
        ArrayList<Entity> chainedTo = new ArrayList<Entity>();
        if (chainData.isEmpty()) {
            return chainedTo;
        }
        for (int i = 0; i < chainData.size(); ++i) {
            UUID uuid;
            Entity found;
            CompoundTag lassoedTag = (CompoundTag)chainData.get(i);
            if (chained.f_19853_.m_5776_() && lassoedTag.m_128441_(CHAIN_TO_ENTITY_ID_TAG)) {
                int id = lassoedTag.m_128451_(CHAIN_TO_ENTITY_ID_TAG);
                if (id == -1) continue;
                found = chained.f_19853_.m_6815_(id);
                if (found != null) {
                    chainedTo.add(found);
                    continue;
                }
                UUID uuid2 = lassoedTag.m_128342_(CHAIN_TO_TAG);
                if (uuid2 == null || chained.f_19853_.m_46003_(uuid2) == null) continue;
                chainedTo.add((Entity)chained.f_19853_.m_46003_(uuid2));
                continue;
            }
            if (!(chained.f_19853_ instanceof ServerLevel) || (uuid = lassoedTag.m_128342_(CHAIN_TO_TAG)) == null || (found = ((ServerLevel)chained.f_19853_).m_8791_(uuid)) == null) continue;
            lassoedTag.m_128405_(CHAIN_TO_ENTITY_ID_TAG, found.m_19879_());
            chainedTo.add(found);
        }
        return chainedTo;
    }

    public static void clearChainData(LivingEntity chained) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)chained);
        entityData.m_128365_(CHAIN_DATA, (Tag)new ListTag());
        ChainProperties.updateData(chained, entityData);
    }

    public static boolean isChainedTo(LivingEntity chained, Entity chainedTo) {
        if (chainedTo == null) {
            return false;
        }
        return ChainProperties.getChainedTo(chained).contains(chainedTo);
    }

    public static void tickChain(LivingEntity chained) {
        List<Entity> chainedToList = ChainProperties.getChainedTo(chained);
        for (Entity chainedOwner : chainedToList) {
            double distance;
            if (chainedOwner == null || !((distance = (double)chained.m_20270_(chainedOwner)) > 7.0)) continue;
            double d0 = (chainedOwner.m_20185_() - chained.m_20185_()) / distance;
            double d1 = (chainedOwner.m_20186_() - chained.m_20186_()) / distance;
            double d2 = (chainedOwner.m_20189_() - chained.m_20189_()) / distance;
            chained.m_20256_(chained.m_20184_().m_82520_(d0 * Math.abs(d0) * 0.4, d1 * Math.abs(d1) * 0.2, d2 * Math.abs(d2) * 0.4));
        }
    }
}

