/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DeathWormAIAttack
extends Goal {
    private final EntityDeathWorm worm;
    private int jumpCooldown = 0;

    public DeathWormAIAttack(EntityDeathWorm worm) {
        this.worm = worm;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        return this.worm.m_5448_() != null && !this.worm.m_20160_() && (this.worm.m_20096_() || this.worm.isInSandStrict()) && this.jumpCooldown <= 0;
    }

    public boolean m_8045_() {
        return this.worm.m_5448_() != null && this.worm.m_5448_().m_6084_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        LivingEntity target = this.worm.m_5448_();
        if (target != null) {
            if (this.worm.isInSand()) {
                BlockPos topSand = this.worm.m_20183_();
                while (this.worm.f_19853_.m_8055_(topSand.m_7494_()).m_204336_(BlockTags.f_13029_)) {
                    topSand = topSand.m_7494_();
                }
                this.worm.m_6034_(this.worm.m_20185_(), (float)topSand.m_123342_() + 0.5f, this.worm.m_20189_());
            }
            if (this.shouldJump()) {
                this.jumpAttack();
            } else {
                this.worm.m_21573_().m_5624_((Entity)target, 1.0);
            }
        }
    }

    public boolean shouldJump() {
        LivingEntity target = this.worm.m_5448_();
        if (target != null) {
            double distanceXZ = this.worm.m_20275_(target.m_20185_(), this.worm.m_20186_(), target.m_20189_());
            float distanceXZSqrt = (float)Math.sqrt(distanceXZ);
            double d0 = this.worm.m_20184_().f_82480_;
            if (distanceXZSqrt < 12.0f && distanceXZSqrt > 2.0f) {
                return this.jumpCooldown <= 0 && (d0 * d0 >= (double)0.03f || this.worm.m_146909_() == 0.0f || Math.abs(this.worm.m_146909_()) >= 10.0f || !this.worm.m_20069_()) && !this.worm.m_20096_();
            }
        }
        return false;
    }

    public void jumpAttack() {
        LivingEntity target = this.worm.m_5448_();
        if (target == null) {
            return;
        }
        this.worm.m_21391_((Entity)target, 260.0f, 30.0f);
        double smoothX = Mth.m_14008_((double)Math.abs(target.m_20185_() - this.worm.m_20185_()), (double)0.0, (double)1.0);
        double smoothZ = Mth.m_14008_((double)Math.abs(target.m_20189_() - this.worm.m_20189_()), (double)0.0, (double)1.0);
        double d0 = (target.m_20185_() - this.worm.m_20185_()) * 0.2 * smoothX;
        double d2 = (target.m_20189_() - this.worm.m_20189_()) * 0.2 * smoothZ;
        float up = (this.worm.m_6134_() > 3.0f ? 0.8f : 0.5f) + this.worm.m_217043_().m_188501_() * 0.5f;
        this.worm.m_20256_(this.worm.m_20184_().m_82520_(d0 * 0.3, (double)up, d2 * 0.3));
        this.worm.m_21573_().m_26573_();
        this.worm.setWormJumping(20);
        this.jumpCooldown = this.worm.m_217043_().m_188503_(32) + 64;
    }

    public void m_8041_() {
        this.worm.m_146926_(0.0f);
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if ((target = this.worm.m_5448_()) != null && this.worm.m_142582_((Entity)target) && this.worm.m_20270_((Entity)target) < 3.0f) {
            this.worm.m_7327_((Entity)target);
        }
        Vec3 vector3d = this.worm.m_20184_();
        if (vector3d.f_82480_ * vector3d.f_82480_ < (double)0.1f && this.worm.m_146909_() != 0.0f) {
            this.worm.m_146926_(Mth.m_14189_((float)this.worm.m_146909_(), (float)0.0f, (float)0.2f));
        } else {
            double d0 = vector3d.m_165924_();
            double d1 = Math.signum(-vector3d.f_82480_) * Math.acos(d0 / vector3d.m_82553_()) * 57.2957763671875;
            this.worm.m_146926_((float)d1);
        }
        if (this.shouldJump()) {
            this.jumpAttack();
        } else if (this.worm.m_21573_().m_26571_()) {
            this.worm.m_21573_().m_5624_((Entity)target, 1.0);
        }
    }
}

