/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.datagen.tags.IafItemTags;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFleePlayer;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIHurtByTarget;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IFlapable;
import com.github.alexthe666.iceandfire.entity.util.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateFlyingCreature;
import com.github.alexthe666.iceandfire.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityAmphithere
extends TamableAnimal
implements ISyncMount,
IAnimatedEntity,
IPhasesThroughBlock,
IFlapable,
IDragonFlute,
IFlyingMount,
IHasCustomizableAttributes,
ICustomMoveController {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityAmphithere.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EntityAmphithere.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FLAP_TICKS = SynchedEntityData.m_135353_(EntityAmphithere.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityAmphithere.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityAmphithere.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static Animation ANIMATION_BITE = Animation.create((int)15);
    public static Animation ANIMATION_BITE_RIDER = Animation.create((int)15);
    public static Animation ANIMATION_WING_BLAST = Animation.create((int)30);
    public static Animation ANIMATION_TAIL_WHIP = Animation.create((int)30);
    public static Animation ANIMATION_SPEAK = Animation.create((int)10);
    public float flapProgress;
    public float groundProgress = 0.0f;
    public float sitProgress = 0.0f;
    public float diveProgress = 0.0f;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer tail_buffer;
    public IFChainBuffer pitch_buffer;
    @Nullable
    public BlockPos orbitPos = null;
    public float orbitRadius = 0.0f;
    public boolean isFallen;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    protected FlightBehavior flightBehavior = FlightBehavior.WANDER;
    protected int ticksCircling = 0;
    private int animationTick;
    private Animation currentAnimation;
    private int flapTicks = 0;
    private int flightCooldown = 0;
    private int ticksFlying = 0;
    private boolean isFlying;
    private boolean changedFlightBehavior = false;
    private int ticksStill = 0;
    private int ridingTime = 0;
    private boolean isSitting;
    private int navigatorType = 0;
    public boolean allowLocalMotionControl = true;
    public boolean allowMousePitchControl = true;
    protected boolean gliding = false;
    protected float glidingSpeedBonus = 0.0f;
    public double minimumSpeed = 0.2f;
    public double maximumSpeed = 0.6f;

    public EntityAmphithere(EntityType<EntityAmphithere> type, Level worldIn) {
        super(type, worldIn);
        if (worldIn.f_46443_) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
        }
        this.f_19793_ = 1.0f;
        this.switchNavigator(0);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, Level world, int x, int z, RandomSource rand) {
        BlockPos pos = new BlockPos(x, entity.m_146904_(), z);
        for (int yDown = 0; yDown < 6 + rand.m_188503_(6); ++yDown) {
            if (world.m_46859_(pos.m_6625_(yDown))) continue;
            return pos.m_6630_(yDown);
        }
        return pos;
    }

    public static boolean canAmphithereSpawnOn(EntityType<EntityAmphithere> parrotIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockState = worldIn.m_8055_(p_223317_3_.m_7495_());
        Block block = blockState.m_60734_();
        return blockState.m_204336_(BlockTags.f_13035_) || block == Blocks.f_50440_ || blockState.m_204336_(BlockTags.f_13106_) || block == Blocks.f_50016_;
    }

    public boolean m_6914_(LevelReader worldIn) {
        if (worldIn.m_45784_((Entity)this) && !worldIn.m_46855_(this.m_20191_())) {
            BlockPos blockpos = this.m_20183_();
            if (blockpos.m_123342_() < worldIn.m_5736_()) {
                return false;
            }
            BlockState blockstate = worldIn.m_8055_(blockpos.m_7495_());
            return blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_204336_(BlockTags.f_13035_);
        }
        return false;
    }

    public static BlockPos getPositionInOrbit(EntityAmphithere entity, Level world, BlockPos orbit, RandomSource rand) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 10.0f;
        if (entity.getCommand() == 2) {
            if (entity.m_21826_() != null) {
                orbit = entity.m_21826_().m_20183_().m_6630_(7);
                radius = 5.0f;
            }
        } else if (entity.hasHomePosition) {
            orbit = entity.homePos.m_6630_(30);
            radius = 30.0f;
        }
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = WorldUtil.containing((double)orbit.m_123341_() + extraX, orbit.m_123342_(), (double)orbit.m_123343_() + extraZ);
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public float m_21692_(@NotNull BlockPos pos) {
        if (this.isFlying()) {
            if (this.f_19853_.m_46859_(pos)) {
                return 10.0f;
            }
            return 0.0f;
        }
        return super.m_21692_(pos);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack != null && itemstack.m_204117_(IafItemTags.BREED_AMPITHERE)) {
            if (this.m_146764_() == 0 && !this.m_27593_()) {
                this.m_21839_(false);
                this.m_27595_(player);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack != null && itemstack.m_204117_(IafItemTags.HEAL_AMPITHERE) && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(5.0f);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (super.m_6071_(player, hand) == InteractionResult.PASS) {
            if (itemstack != null && itemstack.m_41720_() == IafItemRegistry.DRAGON_STAFF.get() && this.m_21830_((LivingEntity)player)) {
                if (player.m_6144_()) {
                    BlockPos pos;
                    this.homePos = pos = this.m_20183_();
                    this.hasHomePosition = true;
                    player.m_5661_((Component)Component.m_237110_((String)"amphithere.command.new_home", (Object[])new Object[]{this.homePos.m_123341_(), this.homePos.m_123342_(), this.homePos.m_123343_()}), true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && this.m_21830_((LivingEntity)player)) {
                if (player.m_21120_(hand).m_41619_()) {
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 2) {
                        this.setCommand(0);
                    }
                    player.m_5661_((Component)Component.m_237115_((String)("amphithere.command." + this.getCommand())), true);
                    this.m_5496_(SoundEvents.f_12609_, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if ((!this.m_21824_() || this.m_21830_((LivingEntity)player)) && !this.m_6162_() && itemstack.m_41619_()) {
                player.m_20329_((Entity)this);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AmphithereAIAttackMelee(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new AmphithereAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new AmphithereAIFleePlayer(this, 32.0f, 0.8, 1.8));
        this.f_21345_.m_25352_(3, (Goal)new AIFlyWander());
        this.f_21345_.m_25352_(3, (Goal)new AIFlyCircle());
        this.f_21345_.m_25352_(3, (Goal)new AILandWander((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIWatchClosestIgnoreRider((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new AmphithereAIHurtByTarget(this, false, new Class[0]));
        this.f_21346_.m_25352_(3, new AmphithereAITargetItems((Mob)this, false));
    }

    public boolean isStill() {
        return Math.abs(this.m_20184_().f_82479_) < 0.05 && Math.abs(this.m_20184_().f_82481_) < 0.05;
    }

    protected void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, this.f_19853_);
            this.navigatorType = 0;
        } else if (navigatorType == 1) {
            this.f_21342_ = new FlyMoveHelper(this);
            this.f_21344_ = new PathNavigateFlyingCreature((Mob)this, this.f_19853_);
            this.navigatorType = 1;
        } else {
            this.f_21342_ = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityAmphithere>(this);
            this.f_21344_ = new PathNavigateFlyingCreature((Mob)this, this.f_19853_);
            this.navigatorType = 2;
        }
    }

    public boolean onLeaves() {
        BlockState state = this.f_19853_.m_8055_(this.m_20183_().m_7495_());
        return state.m_60734_() instanceof LeavesBlock;
    }

    public boolean m_6469_(@NotNull DamageSource source, float damage) {
        if (!this.m_21824_() && this.isFlying() && !this.m_20096_() && source.m_19360_() && !this.f_19853_.f_46443_) {
            this.isFallen = true;
        }
        if (source.m_7639_() instanceof LivingEntity && source.m_7639_().m_20365_((Entity)this) && this.m_21824_() && this.m_21830_((LivingEntity)source.m_7639_())) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public void m_7332_(@NotNull Entity passenger) {
        super.m_7332_(passenger);
        if (!this.m_20363_(passenger) || this.m_21824_()) {
            // empty if block
        }
        if (!this.f_19853_.f_46443_ && !this.m_21824_() && passenger instanceof Player && this.getAnimation() == NO_ANIMATION && this.f_19796_.m_188503_(15) == 0) {
            this.setAnimation(ANIMATION_BITE_RIDER);
        }
        if (!this.f_19853_.f_46443_ && this.getAnimation() == ANIMATION_BITE_RIDER && this.getAnimationTick() == 6 && !this.m_21824_()) {
            passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f);
        }
        float pitch_forward = 0.0f;
        pitch_forward = this.m_146909_() > 0.0f && this.isFlying() ? this.m_146909_() / 45.0f * 0.45f : 0.0f;
        float scaled_ground = this.groundProgress * 0.1f;
        float radius = (this.m_21824_() ? 0.5f : 0.3f) - scaled_ground * 0.5f + pitch_forward;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + (double)0.7f - (double)(scaled_ground * 0.14f) + (double)pitch_forward, this.m_20189_() + extraZ);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(IafItemTags.BREED_AMPITHERE);
    }

    public void m_8107_() {
        boolean notGrounded;
        super.m_8107_();
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        if (this.m_20069_() && this.f_20899_ && this.getControllingPassenger() == null) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.1, this.m_20184_().f_82481_);
        }
        if (this.m_6162_() && this.m_5448_() != null) {
            this.m_6710_(null);
        }
        if (this.m_27593_()) {
            this.setFlying(false);
        }
        if (this.m_21827_() && this.m_5448_() != null) {
            this.m_6710_(null);
        }
        boolean flapping = this.m_142039_();
        boolean flying = this.isFlying() && this.isOverAir() || this.isOverAir() && !this.onLeaves();
        boolean diving = flying && this.m_20184_().f_82480_ <= (double)-0.1f || this.isFallen;
        boolean sitting = this.m_21827_() && !this.isFlying();
        boolean bl = notGrounded = flying || this.getAnimation() == ANIMATION_WING_BLAST;
        if (!this.f_19853_.f_46443_) {
            if (this.m_21827_() && (this.getCommand() != 1 || this.getControllingPassenger() != null)) {
                this.m_21839_(false);
            }
            if (!this.m_21827_() && this.getCommand() == 1 && this.getControllingPassenger() == null) {
                this.m_21839_(true);
            }
            if (this.m_21827_()) {
                this.m_21573_().m_26573_();
            }
            this.ticksFlying = flying ? ++this.ticksFlying : 0;
        }
        if (this.isFlying() && this.m_20096_()) {
            this.setFlying(false);
        }
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
        }
        if (!this.f_19853_.f_46443_) {
            this.ticksCircling = this.flightBehavior == FlightBehavior.CIRCLE ? ++this.ticksCircling : 0;
        }
        if (this.getUntamedRider() != null && !this.m_21824_()) {
            ++this.ridingTime;
        }
        if (this.getUntamedRider() == null) {
            this.ridingTime = 0;
        }
        if (!this.m_21824_() && this.ridingTime > IafConfig.amphithereTameTime && this.getUntamedRider() != null && this.getUntamedRider() instanceof Player) {
            this.f_19853_.m_7605_((Entity)this, (byte)45);
            this.m_21828_((Player)this.getUntamedRider());
            if (this.m_5448_() == this.getUntamedRider()) {
                this.m_6710_(null);
            }
        }
        this.ticksStill = this.isStill() ? ++this.ticksStill : 0;
        if (!this.isFlying() && !this.m_6162_() && (this.m_20096_() && this.f_19796_.m_188503_(200) == 0 && this.flightCooldown == 0 && this.m_20197_().isEmpty() && !this.m_21525_() && this.canMove() || this.m_20186_() < -1.0)) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.5, this.m_20184_().f_82481_);
            this.setFlying(true);
        }
        if (notGrounded && this.groundProgress > 0.0f) {
            this.groundProgress -= 2.0f;
        } else if (!notGrounded && this.groundProgress < 20.0f) {
            this.groundProgress += 2.0f;
        }
        if (diving && this.diveProgress < 20.0f) {
            this.diveProgress += 1.0f;
        } else if (!diving && this.diveProgress > 0.0f) {
            this.diveProgress -= 1.0f;
        }
        if (this.isFlying() && this.getControllingPassenger() == null) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.08, this.m_20184_().f_82481_);
        }
        if (this.isFallen && this.flightBehavior != FlightBehavior.NONE) {
            this.flightBehavior = FlightBehavior.NONE;
        }
        if (this.flightBehavior == FlightBehavior.NONE && this.getControllingPassenger() == null && this.isFlying()) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.3, this.m_20184_().f_82481_);
        }
        if (this.isFlying() && !this.m_20096_() && this.isFallen && this.getControllingPassenger() == null) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.2, this.m_20184_().f_82481_);
            this.m_146926_(Math.max(this.m_146909_() + 5.0f, 75.0f));
        }
        if (this.isFallen && this.m_20096_()) {
            this.setFlying(false);
            this.flightCooldown = this.m_21824_() ? 50 : 12000;
            this.isFallen = false;
        }
        if (flying && this.isOverAir()) {
            if (this.getRidingPlayer() == null && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (this.getRidingPlayer() != null && this.navigatorType != 2) {
                this.switchNavigator(2);
            }
        }
        if (!flying && this.navigatorType != 0) {
            this.switchNavigator(0);
        }
        if ((this.hasHomePosition || this.getCommand() == 2) && this.flightBehavior == FlightBehavior.WANDER) {
            this.flightBehavior = FlightBehavior.CIRCLE;
        }
        if (flapping && this.flapProgress < 10.0f) {
            this.flapProgress += 1.0f;
        } else if (!flapping && this.flapProgress > 0.0f) {
            this.flapProgress -= 1.0f;
        }
        if (this.flapTicks > 0) {
            --this.flapTicks;
        }
        if (this.f_19853_.f_46443_) {
            if (!this.m_20096_()) {
                if (this.m_20160_()) {
                    this.roll_buffer.calculateChainFlapBufferHead(40.0f, 1, 2.0f, 0.5f, (LivingEntity)this);
                } else {
                    this.f_20883_ = this.m_146908_();
                    this.roll_buffer.calculateChainFlapBuffer(70.0f, 1, 2.0f, 0.5f, (LivingEntity)this);
                }
                this.pitch_buffer.calculateChainPitchBuffer(90.0f, 10, 10.0f, 0.5f, (LivingEntity)this);
            }
            this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (LivingEntity)this);
        }
        if (this.changedFlightBehavior) {
            this.changedFlightBehavior = false;
        }
        if (!flapping && (this.m_20184_().f_82480_ > (double)0.15f || this.m_20184_().f_82480_ > 0.0 && this.f_19797_ % 200 == 0) && this.isOverAir()) {
            this.flapWings();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public boolean m_142039_() {
        return this.flapTicks > 0;
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
        this.m_21839_(command == 1);
    }

    @Override
    public void flapWings() {
        this.flapTicks = 20;
    }

    public boolean m_21827_() {
        if (this.f_19853_.f_46443_) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void m_21839_(boolean sitting) {
        if (!this.f_19853_.f_46443_) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        if (sitting) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player) || this.m_5448_() == passenger) continue;
            Player player = (Player)passenger;
            if (!this.m_21824_() || this.m_21805_() == null || !this.m_21805_().equals(player.m_20148_())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Entity getUntamedRider() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            return passenger;
        }
        return null;
    }

    public boolean m_7307_(@NotNull Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_21826_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, IafConfig.amphithereMaxHealth).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, IafConfig.amphithereAttackStrength).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(IafConfig.amphithereMaxHealth);
        this.m_21051_(Attributes.f_22281_).m_22100_(IafConfig.amphithereAttackStrength);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(FLAP_TICKS, (Object)0);
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Flying", this.isFlying());
        compound.m_128405_("FlightCooldown", this.flightCooldown);
        compound.m_128405_("RidingTime", this.ridingTime);
        compound.m_128379_("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.m_128405_("HomeAreaX", this.homePos.m_123341_());
            compound.m_128405_("HomeAreaY", this.homePos.m_123342_());
            compound.m_128405_("HomeAreaZ", this.homePos.m_123343_());
        }
        compound.m_128405_("Command", this.getCommand());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setFlying(compound.m_128471_("Flying"));
        this.flightCooldown = compound.m_128451_("FlightCooldown");
        this.ridingTime = compound.m_128451_("RidingTime");
        this.hasHomePosition = compound.m_128471_("HasHomePosition");
        if (this.hasHomePosition && compound.m_128451_("HomeAreaX") != 0 && compound.m_128451_("HomeAreaY") != 0 && compound.m_128451_("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.m_128451_("HomeAreaX"), compound.m_128451_("HomeAreaY"), compound.m_128451_("HomeAreaZ"));
        }
        this.setCommand(compound.m_128451_("Command"));
        this.setConfigurableAttributes();
    }

    public boolean getCanSpawnHere() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        return this.f_19853_.m_46861_(blockpos.m_7494_());
    }

    public void m_8119_() {
        Vec3 Vector3d1;
        Vec3 Vector3d;
        double dist;
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target != null && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 7 && (dist = this.m_20280_((Entity)target)) < 10.0) {
            target.m_147240_((double)0.6f, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() == 5) {
            this.m_5496_(IafSoundRegistry.AMPHITHERE_GUST, 1.0f, 1.0f);
        }
        if ((this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_BITE_RIDER) && this.getAnimationTick() == 1) {
            this.m_5496_(IafSoundRegistry.AMPHITHERE_BITE, 1.0f, 1.0f);
        }
        if (target != null && this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() > 5 && this.getAnimationTick() < 22 && (dist = this.m_20280_((Entity)target)) < 25.0) {
            target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_() / 2));
            target.f_19812_ = true;
            if (!(this.f_19796_.m_188500_() < this.m_21051_(Attributes.f_22278_).m_22135_())) {
                this.f_19812_ = true;
                double d1 = target.m_20185_() - this.m_20185_();
                double d0 = target.m_20189_() - this.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                Vector3d = this.m_20184_();
                Vector3d1 = new Vec3(d0, 0.0, d1).m_82541_().m_82490_(0.5);
                this.m_20334_(Vector3d.f_82479_ / 2.0 - Vector3d1.f_82479_, this.m_20096_() ? Math.min(0.4, Vector3d.f_82480_ / 2.0 + 0.5) : Vector3d.f_82480_, Vector3d.f_82481_ / 2.0 - Vector3d1.f_82481_);
            }
        }
        if (this.getAnimation() == ANIMATION_TAIL_WHIP && target != null && this.getAnimationTick() == 7 && (dist = this.m_20280_((Entity)target)) < 10.0) {
            target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            target.f_19812_ = true;
            double d1 = target.m_20185_() - this.m_20185_();
            double d0 = target.m_20189_() - this.m_20189_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            Vector3d = this.m_20184_();
            Vector3d1 = new Vec3(d0, 0.0, d1).m_82541_().m_82490_(0.5);
            this.m_20334_(Vector3d.f_82479_ / 2.0 - Vector3d1.f_82479_, this.m_20096_() ? Math.min(0.4, Vector3d.f_82480_ / 2.0 + 0.5) : Vector3d.f_82480_, Vector3d.f_82481_ / 2.0 - Vector3d1.f_82481_);
        }
        if (this.isGoingUp() && !this.f_19853_.f_46443_ && !this.isFlying()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 1.0, 0.0));
            this.setFlying(true);
        }
        if (!this.isOverAir() && this.isFlying() && this.ticksFlying > 25) {
            this.setFlying(false);
        }
        if (this.dismountIAF() && this.isFlying() && this.f_19861_) {
            this.setFlying(false);
        }
        if (this.getUntamedRider() != null && this.getUntamedRider().m_6144_()) {
            if (this.getUntamedRider() instanceof LivingEntity) {
                MiscProperties.setDismountedDragon((LivingEntity)this.getUntamedRider(), true);
            }
            this.getUntamedRider().m_8127_();
        }
        if (this.attack() && this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player) {
            LivingEntity riderTarget = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((Player)this.getControllingPassenger()), 2.5);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
            }
            if (riderTarget != null) {
                riderTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            }
        }
        if (target != null && this.m_21830_(target)) {
            this.m_6710_(null);
        }
        if (target != null && this.f_19861_ && this.isFlying() && this.ticksFlying > 40) {
            this.setFlying(false);
        }
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_TAIL_WHIP && this.getAnimation() != ANIMATION_WING_BLAST && this.getControllingPassenger() == null) {
            if (this.f_19796_.m_188499_()) {
                this.setAnimation(ANIMATION_BITE);
            } else {
                this.setAnimation(this.m_217043_().m_188499_() || this.isFlying() ? ANIMATION_WING_BLAST : ANIMATION_TAIL_WHIP);
            }
            return true;
        }
        return false;
    }

    public boolean isRidingPlayer(Player player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().m_20148_().equals(player.m_20148_());
    }

    @Override
    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    @Override
    public boolean isFlying() {
        if (this.f_19853_.f_46443_) {
            this.isFlying = (Boolean)this.f_19804_.m_135370_(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        if (!this.f_19853_.f_46443_) {
            this.isFlying = flying;
        }
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 3 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return IafSoundRegistry.AMPHITHERE_IDLE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return IafSoundRegistry.AMPHITHERE_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return IafSoundRegistry.AMPHITHERE_DIE;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_BITE_RIDER, ANIMATION_WING_BLAST, ANIMATION_TAIL_WHIP, ANIMATION_SPEAK};
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_8032_();
    }

    protected void m_6677_(@NotNull DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 40;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverWorld, @NotNull AgeableMob ageableEntity) {
        EntityAmphithere amphithere = new EntityAmphithere((EntityType<EntityAmphithere>)((EntityType)IafEntityRegistry.AMPHITHERE.get()), this.f_19853_);
        amphithere.setVariant(this.getVariant());
        return amphithere;
    }

    public int m_213860_() {
        return 10;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_217043_().m_188503_(5));
        return spawnDataIn;
    }

    @Override
    public boolean canPhaseThroughBlock(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() instanceof LeavesBlock;
    }

    public void m_20334_(double pX, double pY, double pZ) {
        super.m_20334_(pX, pY, pZ);
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.canMove() && !this.m_20160_()) {
            super.m_7023_(pTravelVector.m_82542_(0.0, 1.0, 0.0));
            return;
        }
        if (this.allowLocalMotionControl && this.getControllingPassenger() != null) {
            LivingEntity rider = this.getControllingPassenger();
            if (rider == null) {
                super.m_7023_(pTravelVector);
                return;
            }
            this.m_146922_(rider.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(rider.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = this.m_146908_();
            this.f_20886_ = this.f_20885_;
            this.f_20885_ = this.f_20883_;
            if (this.isHovering() || this.isFlying()) {
                double forward = 1.0;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_) * 0.5f;
                float airSpeedModifier = (float)((double)5.2f + 1.0 * Mth.m_144914_((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= airSpeedModifier;
                this.gliding = this.allowMousePitchControl && rider.m_20142_();
                this.gliding = true;
                if (!this.gliding) {
                    speed += this.glidingSpeedBonus * (rider.m_20142_() ? 1.5f : 1.0f);
                    forward *= rider.f_20902_ > 0.0f ? 1.0 : 0.5;
                    strafing *= (double)0.4f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0;
                    } else if (this.m_6109_()) {
                        // empty if block
                    }
                } else {
                    speed *= 1.5f;
                    strafing *= (double)0.1f;
                    this.glidingSpeedBonus = (float)Mth.m_14008_((double)((double)this.glidingSpeedBonus + this.m_20184_().f_82480_ * -0.05), (double)-0.8, (double)1.5);
                    speed += this.glidingSpeedBonus;
                    forward = Mth.m_14154_((float)Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    vertical = Mth.m_14154_((float)Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = Math.max(vertical, 0.5);
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = Math.min(vertical, -0.5);
                    } else if (this.isGoingUp() && this.isGoingDown()) {
                        vertical = 0.0;
                    } else if (this.m_146909_() < 0.0f) {
                        vertical *= 1.0;
                    } else if (this.m_146909_() > 0.0f) {
                        vertical *= -1.0;
                    } else if (this.m_6109_()) {
                        // empty if block
                    }
                }
                this.glidingSpeedBonus = (float)((double)this.glidingSpeedBonus - (double)this.glidingSpeedBonus * 0.01);
                if (this.m_6109_()) {
                    this.f_20887_ = speed * 0.1f;
                    this.m_7910_(speed);
                    this.m_19920_(this.f_20887_, new Vec3(strafing, vertical, forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82559_(new Vec3(0.9, 0.9, 0.9)));
                    Vec3 currentMotion = this.m_20184_();
                    if (this.f_19862_) {
                        currentMotion = new Vec3(currentMotion.f_82479_, 0.1, currentMotion.f_82481_);
                    }
                    this.m_20256_(currentMotion);
                    this.m_21043_((LivingEntity)this, false);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
                return;
            }
            if (this.m_20069_() || this.m_20077_()) {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.5;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.5;
                }
                this.f_20887_ = speed;
                this.m_7910_(speed);
                this.m_21564_((float)forward);
                super.m_7023_(pTravelVector.m_82520_(strafing, vertical, forward));
                return;
            }
            double forward = rider.f_20902_;
            double strafing = rider.f_20900_;
            double vertical = pTravelVector.f_82480_;
            float speed = (float)this.m_21133_(Attributes.f_22279_);
            float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
            forward *= (double)(speed *= groundSpeedModifier);
            forward *= rider.m_20142_() ? (double)1.2f : 1.0;
            forward *= rider.f_20902_ > 0.0f ? 1.0 : (double)0.2f;
            strafing *= (double)0.05f;
            if (this.m_6109_()) {
                this.f_20887_ = speed * 0.1f;
                this.m_7910_(speed);
                super.m_7023_(new Vec3(strafing, vertical, forward));
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
            this.m_146872_();
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean canMove() {
        return this.getControllingPassenger() == null && this.sitProgress == 0.0f && !this.m_21827_();
    }

    public void m_7822_(byte id) {
        if (id == 45) {
            this.playEffect();
        } else {
            super.m_7822_(id);
        }
    }

    protected void playEffect() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    @Override
    public void onHearFlute(Player player) {
        if (!this.m_20096_() && this.m_21824_()) {
            this.isFallen = true;
        }
    }

    public boolean m_21532_() {
        return true;
    }

    @Override
    public double getFlightSpeedModifier() {
        return 0.555;
    }

    @Override
    public boolean fliesLikeElytra() {
        return !this.m_20096_();
    }

    private boolean isOverAir() {
        return this.f_19853_.m_46859_(this.m_20183_().m_7495_());
    }

    public boolean canBlockPosBeSeen(BlockPos pos) {
        Vec3 Vector3d1;
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(Vector3d, Vector3d1 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public static enum FlightBehavior {
        CIRCLE,
        WANDER,
        NONE;

    }

    class AIFlyWander
    extends Goal {
        BlockPos target;

        public boolean m_8036_() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.WANDER || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                this.target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.m_146903_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.m_146907_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.f_19796_);
                EntityAmphithere.this.orbitPos = null;
                return !EntityAmphithere.this.m_21566_().m_24995_() || EntityAmphithere.this.ticksStill >= 50;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(Entity e) {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            if (!this.isDirectPathBetweenPoints((Entity)EntityAmphithere.this)) {
                this.target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.m_146903_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.m_146907_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.f_19796_);
            }
            if (EntityAmphithere.this.f_19853_.m_46859_(this.target)) {
                EntityAmphithere.this.f_21342_.m_6849_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, 0.25);
                if (EntityAmphithere.this.m_5448_() == null) {
                    EntityAmphithere.this.m_21563_().m_24950_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, 180.0f, 20.0f);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AIFlyCircle
    extends Goal {
        BlockPos target;

        public boolean m_8036_() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.CIRCLE || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                EntityAmphithere.this.orbitPos = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.m_146903_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.m_146907_() + EntityAmphithere.this.f_19796_.m_188503_(30) - 15, EntityAmphithere.this.f_19796_);
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.orbitPos, EntityAmphithere.this.f_19796_);
                return true;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints() {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            if (!this.isDirectPathBetweenPoints()) {
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.orbitPos, EntityAmphithere.this.f_19796_);
            }
            if (EntityAmphithere.this.f_19853_.m_46859_(this.target)) {
                EntityAmphithere.this.f_21342_.m_6849_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, 0.25);
                if (EntityAmphithere.this.m_5448_() == null) {
                    EntityAmphithere.this.m_21563_().m_24950_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, 180.0f, 20.0f);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AILandWander
    extends WaterAvoidingRandomStrollGoal {
        public AILandWander(PathfinderMob creature, double speed) {
            super(creature, speed, 10.0f);
        }

        public boolean m_8036_() {
            return this.f_25725_.m_20096_() && super.m_8036_() && ((EntityAmphithere)this.f_25725_).canMove();
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class FlyMoveHelper
    extends MoveControl {
        public FlyMoveHelper(EntityAmphithere entity) {
            super((Mob)entity);
            this.f_24978_ = 1.75;
        }

        public void m_8126_() {
            if (!EntityAmphithere.this.canMove()) {
                return;
            }
            if (EntityAmphithere.this.f_19862_) {
                EntityAmphithere.this.m_146922_(EntityAmphithere.this.m_146908_() + 180.0f);
                this.f_24978_ = 0.1f;
                BlockPos target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.f_19853_, EntityAmphithere.this.m_146903_() + EntityAmphithere.this.f_19796_.m_188503_(15) - 7, EntityAmphithere.this.m_146907_() + EntityAmphithere.this.f_19796_.m_188503_(15) - 7, EntityAmphithere.this.f_19796_);
                this.f_24975_ = target.m_123341_();
                this.f_24976_ = target.m_123342_();
                this.f_24977_ = target.m_123343_();
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double d0 = this.f_24975_ - EntityAmphithere.this.m_20185_();
                double d1 = this.f_24976_ - EntityAmphithere.this.m_20186_();
                double d2 = this.f_24977_ - EntityAmphithere.this.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)Mth.m_14116_((float)((float)d3))) < 6.0 && EntityAmphithere.this.m_5448_() == null) {
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.WANDER && EntityAmphithere.this.f_19796_.m_188503_(30) == 0) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.CIRCLE && EntityAmphithere.this.f_19796_.m_188503_(5) == 0 && EntityAmphithere.this.ticksCircling > 150) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.WANDER;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (EntityAmphithere.this.hasHomePosition && EntityAmphithere.this.flightBehavior != FlightBehavior.NONE || EntityAmphithere.this.getCommand() == 2) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                    }
                }
                if (d3 < 1.0 && EntityAmphithere.this.m_5448_() == null) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    EntityAmphithere.this.m_20256_(EntityAmphithere.this.m_20184_().m_82542_(0.5, 0.5, 0.5));
                } else {
                    EntityAmphithere.this.m_20256_(EntityAmphithere.this.m_20184_().m_82520_(d0 / d3 * 0.5 * this.f_24978_, d1 / d3 * 0.5 * this.f_24978_, d2 / d3 * 0.5 * this.f_24978_));
                    float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
                    EntityAmphithere.this.m_146926_(f1);
                    if (EntityAmphithere.this.m_5448_() == null) {
                        EntityAmphithere.this.m_146922_(-((float)Mth.m_14136_((double)EntityAmphithere.this.m_20184_().f_82479_, (double)EntityAmphithere.this.m_20184_().f_82481_)) * 57.295776f);
                        EntityAmphithere.this.f_20883_ = EntityAmphithere.this.m_146908_();
                    } else {
                        double d4 = EntityAmphithere.this.m_5448_().m_20185_() - EntityAmphithere.this.m_20185_();
                        double d5 = EntityAmphithere.this.m_5448_().m_20189_() - EntityAmphithere.this.m_20189_();
                        EntityAmphithere.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                        EntityAmphithere.this.f_20883_ = EntityAmphithere.this.m_146908_();
                    }
                }
            }
        }
    }
}

