/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.iceandfire.client.model.ModelAmphithere;
import com.github.alexthe666.iceandfire.client.model.ModelCockatrice;
import com.github.alexthe666.iceandfire.client.model.ModelCyclops;
import com.github.alexthe666.iceandfire.client.model.ModelHippogryph;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.model.ModelStymphalianBird;
import com.github.alexthe666.iceandfire.client.model.ModelTroll;
import com.github.alexthe666.iceandfire.entity.EntityMobSkull;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RenderMobSkull
extends EntityRenderer<EntityMobSkull> {
    private static final Map<String, ResourceLocation> SKULL_TEXTURE_CACHE = Maps.newHashMap();
    private final ModelHippogryph hippogryphModel = new ModelHippogryph();
    private final ModelCyclops cyclopsModel = new ModelCyclops();
    private final ModelCockatrice cockatriceModel = new ModelCockatrice();
    private final ModelStymphalianBird stymphalianBirdModel = new ModelStymphalianBird();
    private final ModelTroll trollModel = new ModelTroll();
    private final ModelAmphithere amphithereModel = new ModelAmphithere();
    private final ModelHydraHead hydraModel;
    private final TabulaModel seaSerpentModel;

    public RenderMobSkull(EntityRendererProvider.Context context, AdvancedEntityModel seaSerpentModel) {
        super(context);
        this.seaSerpentModel = (TabulaModel)seaSerpentModel;
        this.hydraModel = new ModelHydraHead(0);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX, float rotY, float rotZ) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = rotY;
        cube.rotateAngleZ = rotZ;
    }

    public void render(@NotNull EntityMobSkull entity, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-180.0f));
        matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(180.0f - entity.getYaw()));
        float f = 0.0625f;
        float size = 1.0f;
        matrixStackIn.m_85841_(size, size, size);
        matrixStackIn.m_85837_(0.0, entity.isOnWall() ? (double)-0.24f : (double)-0.12f, 0.5);
        this.renderForEnum(entity.getSkullType(), entity.isOnWall(), matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderForEnum(EnumSkullType skull, boolean onWall, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getSkullTexture(skull)));
        switch (skull) {
            case HIPPOGRYPH: {
                matrixStackIn.m_85837_(0.0, -0.0, (double)-0.2f);
                matrixStackIn.m_85841_(1.2f, 1.2f, 1.2f);
                this.hippogryphModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hippogryphModel.Head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-5.0), 0.0f, 0.0f);
                this.hippogryphModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case CYCLOPS: {
                matrixStackIn.m_85837_(0.0, (double)1.8f, -0.5);
                matrixStackIn.m_85841_(2.25f, 2.25f, 2.25f);
                this.cyclopsModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cyclopsModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cyclopsModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case COCKATRICE: {
                if (onWall) {
                    matrixStackIn.m_85837_(0.0, 0.0, (double)0.35f);
                }
                this.cockatriceModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cockatriceModel.head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cockatriceModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case STYMPHALIAN: {
                if (!onWall) {
                    matrixStackIn.m_85837_(0.0, 0.0, (double)-0.35f);
                }
                this.stymphalianBirdModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.stymphalianBirdModel.HeadBase, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.stymphalianBirdModel.HeadBase.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case TROLL: {
                matrixStackIn.m_85837_(0.0, 1.0, (double)-0.35f);
                if (onWall) {
                    matrixStackIn.m_85837_(0.0, 0.0, (double)0.35f);
                }
                this.trollModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.trollModel.head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-20.0), 0.0f, 0.0f);
                this.trollModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case AMPHITHERE: {
                matrixStackIn.m_85837_(0.0, (double)-0.2f, (double)0.7f);
                matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
                this.amphithereModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.amphithereModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.amphithereModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SEASERPENT: {
                matrixStackIn.m_85837_(0.0, (double)-0.35f, (double)0.8f);
                matrixStackIn.m_85841_(2.5f, 2.5f, 2.5f);
                this.seaSerpentModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.seaSerpentModel.getCube("Head"), onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.seaSerpentModel.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HYDRA: {
                matrixStackIn.m_85837_(0.0, (double)-0.2f, (double)-0.1f);
                matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
                this.hydraModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hydraModel.Head1, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.hydraModel.Head1.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(EntityMobSkull entity) {
        return this.getSkullTexture(entity.getSkullType());
    }

    public ResourceLocation getSkullTexture(EnumSkullType skull) {
        String s = "iceandfire:textures/models/skulls/skull_" + skull.name().toLowerCase(Locale.ROOT) + ".png";
        ResourceLocation resourcelocation = SKULL_TEXTURE_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            SKULL_TEXTURE_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

