/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiDragonForge
extends AbstractContainerScreen<ContainerDragonForge> {
    private static final ResourceLocation TEXTURE_FIRE = new ResourceLocation("iceandfire:textures/gui/dragonforge_fire.png");
    private static final ResourceLocation TEXTURE_ICE = new ResourceLocation("iceandfire:textures/gui/dragonforge_ice.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = new ResourceLocation("iceandfire:textures/gui/dragonforge_lightning.png");
    private final ContainerDragonForge tileFurnace;
    private final int dragonType;

    public GuiDragonForge(ContainerDragonForge container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tileFurnace = container;
        this.dragonType = this.tileFurnace.fireType;
    }

    protected void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        Font font = this.getMinecraft().f_91062_;
        if (this.tileFurnace != null) {
            String s = I18n.m_118938_((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.dragonType) + "_core"), (Object[])new Object[0]);
            font.m_92883_(ms, s, (float)(this.f_97726_ / 2 - font.m_92895_(s) / 2), 6.0f, 0x404040);
        }
        font.m_92889_(ms, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack ms, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = TEXTURE_LIGHTNING;
        if (this.dragonType == 0) {
            texture = TEXTURE_FIRE;
        } else if (this.dragonType == 1) {
            texture = TEXTURE_ICE;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(ms, k, l, 0, 0, this.f_97726_, this.f_97727_);
        int i1 = this.getCookTime(126);
        this.m_93228_(ms, k + 12, l + 23, 0, 166, i1, 38);
    }

    private int getCookTime(int p_175381_1_) {
        int maxCookTime;
        BlockEntity te = IceAndFire.PROXY.getRefrencedTE();
        int j = 0;
        List recipes = this.getMinecraft().f_91073_.m_7465_().m_44013_((RecipeType)IafRecipeRegistry.DRAGON_FORGE_TYPE.get()).stream().filter(item -> item.isValidInput(this.tileFurnace.m_38853_(0).m_7993_()) && item.isValidBlood(this.tileFurnace.m_38853_(1).m_7993_())).collect(Collectors.toList());
        int n = maxCookTime = recipes.isEmpty() ? 100 : ((DragonForgeRecipe)recipes.get(0)).getCookTime();
        if (te instanceof TileEntityDragonforge) {
            j = Math.min(((TileEntityDragonforge)te).cookTime, maxCookTime);
        }
        return j != 0 ? j * p_175381_1_ / maxCookTime : 0;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
    }
}

