/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.processor;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class HolystoneReplaceProcessor
extends StructureProcessor {
    public static final Codec<HolystoneReplaceProcessor> CODEC = Codec.unit(() -> INSTANCE);
    public static final HolystoneReplaceProcessor INSTANCE = new HolystoneReplaceProcessor();
    private final Map<Block, Block> replacements = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Blocks.f_50652_, (Block)AetherBlocks.HOLYSTONE_BRICKS.get());
        map.put(Blocks.f_50079_, (Block)AetherBlocks.HOLYSTONE_BRICKS.get());
        map.put(Blocks.f_50157_, (Block)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get());
        map.put(Blocks.f_50633_, (Block)AetherBlocks.HOLYSTONE_BRICK_STAIRS.get());
        map.put(Blocks.f_50409_, (Block)AetherBlocks.HOLYSTONE_BRICK_SLAB.get());
        map.put(Blocks.f_50647_, (Block)AetherBlocks.HOLYSTONE_BRICK_SLAB.get());
        map.put(Blocks.f_50274_, (Block)AetherBlocks.HOLYSTONE_BRICK_WALL.get());
        map.put(Blocks.f_50275_, (Block)AetherBlocks.HOLYSTONE_BRICK_WALL.get());
    });

    private HolystoneReplaceProcessor() {
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos otherPos, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        Block block = this.replacements.get(relativeBlockInfo.f_74676_.m_60734_());
        if (block == null) {
            return relativeBlockInfo;
        }
        BlockState originalState = relativeBlockInfo.f_74676_;
        BlockState newState = block.m_49966_();
        if (originalState.m_61138_((Property)StairBlock.f_56841_)) {
            newState = (BlockState)newState.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)originalState.m_61143_((Property)StairBlock.f_56841_)));
        }
        if (originalState.m_61138_((Property)StairBlock.f_56842_)) {
            newState = (BlockState)newState.m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)originalState.m_61143_((Property)StairBlock.f_56842_)));
        }
        if (originalState.m_61138_((Property)SlabBlock.f_56353_)) {
            newState = (BlockState)newState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)originalState.m_61143_((Property)SlabBlock.f_56353_)));
        }
        return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.f_74675_, newState, relativeBlockInfo.f_74677_);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)AetherStructureProcessors.HOLYSTONE_REPLACE.get();
    }
}

