/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.ban;

import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class AbstractPlacementBanRecipe<T, S extends Predicate<T>>
implements Recipe<Container> {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    @Nullable
    private final ResourceKey<Biome> biomeKey;
    @Nullable
    private final TagKey<Biome> biomeTag;
    protected final BlockStateIngredient bypassBlock;
    protected final S ingredient;

    public AbstractPlacementBanRecipe(RecipeType<?> type, ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, BlockStateIngredient bypassBlock, S ingredient) {
        this.type = type;
        this.id = id;
        this.biomeKey = biomeKey;
        this.biomeTag = biomeTag;
        this.bypassBlock = bypassBlock;
        this.ingredient = ingredient;
    }

    public boolean matches(Level level, BlockPos pos, T object) {
        if (this.bypassBlock.isEmpty() || !this.bypassBlock.test(level.m_8055_(pos))) {
            if (this.biomeKey != null) {
                return this.getIngredient().test(object) && level.m_204166_(pos).m_203565_(this.biomeKey);
            }
            if (this.biomeTag != null) {
                return this.getIngredient().test(object) && level.m_204166_(pos).m_203656_(this.biomeTag);
            }
            return this.getIngredient().test(object);
        }
        return false;
    }

    @Nullable
    public ResourceKey<Biome> getBiomeKey() {
        return this.biomeKey;
    }

    @Nullable
    public TagKey<Biome> getBiomeTag() {
        return this.biomeTag;
    }

    public BlockStateIngredient getBypassBlock() {
        return this.bypassBlock;
    }

    public S getIngredient() {
        return this.ingredient;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_5874_(Container container) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }
}

