/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.SetVehiclePacket;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.simple.SimpleChannel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void travel(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!((Boolean)AetherConfig.SERVER.disable_falling_to_overworld.get()).booleanValue() && serverLevel.m_46472_() == LevelUtil.destinationDimension() && entity.m_20186_() <= (double)serverLevel.m_141937_() && !entity.m_20159_() && serverLevel.m_204166_(entity.m_20183_()).m_203656_(AetherTags.Biomes.FALL_TO_OVERWORLD)) {
                ItemEntity itemEntity;
                LazyOptional<DroppedItem> droppedItem;
                Projectile projectile;
                if (entity instanceof Player || entity.m_20160_() || entity instanceof Saddleable && ((Saddleable)entity).m_6254_()) {
                    EntityMixin.entityFell(entity);
                } else if (entity instanceof Projectile && (projectile = (Projectile)entity).m_37282_() instanceof Player) {
                    EntityMixin.entityFell((Entity)projectile);
                } else if (entity instanceof ItemEntity && (droppedItem = DroppedItem.get(itemEntity = (ItemEntity)entity)).isPresent() && droppedItem.resolve().isPresent() && (itemEntity.m_32056_() != null && itemEntity.m_9236_().m_46003_(itemEntity.m_32056_()) != null || ((DroppedItem)droppedItem.resolve().get()).getOwner() instanceof Player)) {
                    EntityMixin.entityFell(entity);
                }
            }
        }
    }

    @Nullable
    private static Entity entityFell(Entity entity) {
        ServerLevel destination;
        Level serverLevel = entity.m_9236_();
        MinecraftServer minecraftserver = serverLevel.m_7654_();
        if (minecraftserver != null && (destination = minecraftserver.m_129880_(LevelUtil.returnDimension())) != null && LevelUtil.returnDimension() != LevelUtil.destinationDimension()) {
            List passengers = entity.m_20197_();
            serverLevel.m_46473_().m_6180_("aether_fall");
            entity.m_20091_();
            Entity target = entity.changeDimension(destination, (ITeleporter)new AetherPortalForcer(destination, false));
            serverLevel.m_46473_().m_7238_();
            if (target != null) {
                for (Entity passenger : passengers) {
                    passenger.m_8127_();
                    Entity nextPassenger = EntityMixin.entityFell(passenger);
                    if (nextPassenger == null) continue;
                    nextPassenger.m_20329_(target);
                    if (!(target instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new SetVehiclePacket(nextPassenger.m_19879_(), target.m_19879_()), (ServerPlayer)serverPlayer);
                }
                if (target instanceof ServerPlayer) {
                    DimensionHooks.teleportationTimer = 500;
                }
            }
            return target;
        }
        return null;
    }
}

