/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei.categories.item;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.integration.rei.AetherREIServerPlugin;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeDisplay;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.EnchantingRecipe;
import com.aetherteam.aether.recipe.recipes.item.FreezingRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.aetherteam.nitrogen.integration.rei.categories.AbstractRecipeCategory;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableDouble;

public class AetherCookingRecipeCategory<R extends Recipe<?>>
extends AbstractRecipeCategory<AetherCookingRecipeDisplay<R>> {
    public static final ResourceLocation ALTAR_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/altar.png");
    public static final ResourceLocation FREEZER_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/freezer.png");
    public static final ResourceLocation INCUBATOR_TEXTURE = new ResourceLocation("aether", "textures/gui/menu/incubator.png");
    protected final Supplier<WidgetWithBounds> fuelIndicator = () -> AetherCookingRecipeCategory.fuelIndicator(texture);
    protected final Supplier<WidgetWithBounds> animatedProgressArrow;

    public AetherCookingRecipeCategory(String id, CategoryIdentifier<AetherCookingRecipeDisplay<R>> categoryIdentifier, int width, int height, Renderer icon, ResourceLocation texture) {
        this(id, categoryIdentifier, width, height, icon, texture, () -> AetherCookingRecipeCategory.animatedArrow(texture, 100));
    }

    public AetherCookingRecipeCategory(String id, CategoryIdentifier<AetherCookingRecipeDisplay<R>> categoryIdentifier, int width, int height, Renderer icon, ResourceLocation texture, Supplier<WidgetWithBounds> animatedProgressArrow) {
        super(id, categoryIdentifier, width, height, icon);
        this.animatedProgressArrow = animatedProgressArrow;
    }

    public static AetherCookingRecipeCategory<AltarRepairRecipe> altarRepair() {
        return new AetherCookingRecipeCategory<AltarRepairRecipe>("altar.repairing", AetherREIServerPlugin.ALTAR_REPAIR, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), ALTAR_TEXTURE);
    }

    public static AetherCookingRecipeCategory<EnchantingRecipe> altarEnchanting() {
        return new AetherCookingRecipeCategory<EnchantingRecipe>("altar.enchanting", AetherREIServerPlugin.ALTAR_ENCHANTING, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), ALTAR_TEXTURE);
    }

    public static AetherCookingRecipeCategory<FreezingRecipe> freezing() {
        return new AetherCookingRecipeCategory<FreezingRecipe>("freezing", AetherREIServerPlugin.FREEZING, 140, 39, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get())), FREEZER_TEXTURE);
    }

    public static AetherCookingRecipeCategory<IncubationRecipe> incubating() {
        return new AetherCookingRecipeCategory<IncubationRecipe>("incubating", AetherREIServerPlugin.INCUBATING, 88, 54, (Renderer)EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get())), INCUBATOR_TEXTURE, () -> {
            final MutableDouble lastTick = new MutableDouble(0.0);
            Rectangle widgetBound = new Rectangle(8, -13, 10, 54);
            return Widgets.wrapRenderer((Rectangle)widgetBound, (Renderer)new Renderer(){

                public void render(PoseStack poseStack, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)INCUBATOR_TEXTURE);
                    lastTick.getAndAdd((double)delta);
                    if (lastTick.getValue() > 5700.0) {
                        lastTick.setValue(0.0);
                    }
                    int textureLength = 54;
                    int scissorOffset = (int)Math.round((double)textureLength * (lastTick.getValue() / 5700.0));
                    Gui.m_93133_((PoseStack)poseStack, (int)bounds.x, (int)bounds.y, (float)103.0f, (float)16.0f, (int)9, (int)54, (int)256, (int)256);
                    Gui.m_239260_((int)bounds.x, (int)(bounds.y + textureLength - scissorOffset), (int)(bounds.x + 10), (int)(bounds.y + textureLength * 2 - scissorOffset));
                    Gui.m_93133_((PoseStack)poseStack, (int)bounds.x, (int)bounds.y, (float)179.0f, (float)16.0f, (int)10, (int)54, (int)256, (int)256);
                    Gui.m_240060_();
                }

                public int getZ() {
                    return 0;
                }

                public void setZ(int z) {
                }
            });
        });
    }

    private static WidgetWithBounds fuelIndicator(final ResourceLocation texture) {
        return Widgets.wrapRenderer((Rectangle)new Rectangle(14, 13), (Renderer)new Renderer(){

            public void render(PoseStack poseStack, Rectangle bounds, int mouseX, int mouseY, float delta) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                Gui.m_93133_((PoseStack)poseStack, (int)bounds.x, (int)bounds.y, (float)176.0f, (float)0.0f, (int)14, (int)13, (int)256, (int)256);
            }

            public int getZ() {
                return 0;
            }

            public void setZ(int z) {
            }
        });
    }

    private static WidgetWithBounds animatedArrow(final ResourceLocation texture, final int burnTime) {
        final MutableDouble lastTick = new MutableDouble(0.0);
        return Widgets.wrapRenderer((Rectangle)new Rectangle(23, 16), (Renderer)new Renderer(){

            public void render(PoseStack poseStack, Rectangle bounds, int mouseX, int mouseY, float delta) {
                lastTick.getAndAdd((double)delta);
                if (lastTick.getValue() > (double)burnTime) {
                    lastTick.setValue(0.0);
                }
                int xOffset = 23 - (int)Math.round(23.0 * (lastTick.getValue() / (double)burnTime));
                ResourceLocation blankArrow = REIRuntime.getInstance().getDefaultDisplayTexture(false);
                RenderSystem.m_157456_((int)0, (ResourceLocation)blankArrow);
                Gui.m_93133_((PoseStack)poseStack, (int)bounds.x, (int)bounds.y, (float)106.0f, (float)91.0f, (int)24, (int)17, (int)256, (int)256);
                Gui.m_239260_((int)(bounds.x - xOffset), (int)bounds.y, (int)(bounds.x + 23 - xOffset), (int)(bounds.y + 16));
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                Gui.m_93133_((PoseStack)poseStack, (int)bounds.x, (int)bounds.y, (float)176.0f, (float)14.0f, (int)23, (int)16, (int)256, (int)256);
                Gui.m_240060_();
            }

            public int getZ() {
                return 0;
            }

            public void setZ(int z) {
            }
        });
    }

    public List<Widget> setupDisplay(AetherCookingRecipeDisplay<R> display, Rectangle bounds) {
        List widgets = super.setupDisplay(display, bounds);
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        DecimalFormat df = new DecimalFormat("###.##");
        float experience = display.getExperience();
        int cookingTime = display.getCookingTime();
        MutableComponent cookInfo = experience > 0.0f ? Component.m_237110_((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(experience), df.format((double)cookingTime / 20.0)}) : Component.m_237110_((String)"category.rei.campfire.time", (Object[])new Object[]{df.format((double)cookingTime / 20.0)});
        Point labelPoint = new Point(bounds.x + bounds.width - 5, bounds.y + 5);
        if (display.isIncubation()) {
            int n = labelPoint.x;
            int n2 = bounds.getCenterY();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            labelPoint.move(n, n2 - 9 / 2);
        }
        widgets.add(Widgets.createLabel((Point)labelPoint, (Component)cookInfo).noShadow().rightAligned().color(-12566464, -4473925));
        Point arrowPoint = new Point(startPoint.x + 24, startPoint.y + 8);
        WidgetWithBounds arrowWidget = this.animatedProgressArrow.get();
        arrowWidget.getBounds().translate(arrowPoint.x, arrowPoint.y);
        widgets.add(arrowWidget);
        if (display.isIncubation()) {
            startPoint.translate(6, 5);
        }
        WidgetWithBounds fuelWidget = this.fuelIndicator.get();
        fuelWidget.getBounds().move(startPoint.x + 2, startPoint.y + 20);
        widgets.add(fuelWidget);
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        List outputEntries = display.getOutputEntries();
        if (outputEntries.size() > 0) {
            widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
            widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)outputEntries.get(0)).disableBackground().markOutput());
        }
        return widgets;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.aether.jei." + this.id));
    }
}

