/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.SunSpirit;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FireCrystal
extends AbstractCrystal {
    private double xPower;
    private double yPower;
    private double zPower;

    public FireCrystal(EntityType<? extends FireCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public FireCrystal(Level level, Entity shooter) {
        this((EntityType<? extends FireCrystal>)((EntityType)AetherEntityTypes.FIRE_CRYSTAL.get()), level);
        this.m_5602_(shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_() + 1.0, shooter.m_20189_());
        float rotation = this.f_19796_.m_188501_() * 360.0f;
        this.xPower = (double)Mth.m_14031_((float)rotation) * 0.5;
        this.zPower = (double)(-Mth.m_14089_((float)rotation)) * 0.5;
        this.yPower = (double)Mth.m_14031_((float)(this.f_19796_.m_188501_() * 360.0f)) * 0.45;
        double verticalOffset = 1.0 - Math.abs(this.yPower);
        this.xPower *= verticalOffset;
        this.zPower *= verticalOffset;
        this.m_20334_(this.xPower, this.yPower, this.zPower);
    }

    @Override
    protected void tickMovement() {
        SunSpirit sunSpirit;
        Entity entity;
        if (!this.m_9236_().m_5776_() && (this.m_37282_() == null || !this.m_37282_().m_6084_() || (entity = this.m_37282_()) instanceof SunSpirit && (sunSpirit = (SunSpirit)entity).getDungeon() != null && sunSpirit.getDungeon().dungeonPlayers().isEmpty())) {
            if (this.getImpactExplosionSoundEvent() != null) {
                this.m_5496_(this.getImpactExplosionSoundEvent(), 1.0f, 1.0f);
            }
            this.m_146870_();
        }
        super.tickMovement();
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6469_(AetherDamageTypes.fireCrystal((Entity)this, this.m_37282_()), 20.0f)) {
            livingEntity.m_20254_(6);
            if (this.getImpactExplosionSoundEvent() != null) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getImpactExplosionSoundEvent(), SoundSource.HOSTILE, 2.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.2f);
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        this.m_5834_();
        switch (result.m_82434_()) {
            case NORTH: 
            case SOUTH: {
                this.zPower = -this.zPower;
                break;
            }
            case UP: 
            case DOWN: {
                this.yPower = -this.yPower;
                break;
            }
            case WEST: 
            case EAST: {
                this.xPower = -this.xPower;
            }
        }
        this.m_20334_(this.xPower, this.yPower, this.zPower);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        Entity entity = source.m_7639_();
        if (entity != null) {
            if (!this.m_9236_().m_5776_()) {
                Vec3 vec3 = entity.m_20154_();
                this.m_20256_(vec3);
                this.xPower = vec3.m_7096_() * 0.25;
                this.yPower = vec3.m_7098_() * 0.15;
                this.zPower = vec3.m_7094_() * 0.25;
            }
            return true;
        }
        return false;
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return ParticleTypes.f_123744_;
    }

    @Override
    @Nullable
    protected SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_FIRE_CRYSTAL_EXPLODE.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("XSpeed", this.xPower);
        tag.m_128347_("YSpeed", this.yPower);
        tag.m_128347_("ZSpeed", this.zPower);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.xPower = tag.m_128459_("XSpeed");
        this.yPower = tag.m_128459_("YSpeed");
        this.zPower = tag.m_128459_("ZSpeed");
    }
}

