/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.level;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.mixin.mixins.client.accessor.LevelRendererAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public class AetherSkyRenderEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation CLOUDS_LOCATION = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private final DimensionSpecialEffects OVERWORLD = new DimensionSpecialEffects.OverworldEffects();
    private final float[] sunriseCol = new float[4];
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.f_82478_;

    public AetherSkyRenderEffects() {
        super(9.5f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (((Boolean)AetherConfig.CLIENT.colder_lightmap.get()).booleanValue()) {
            Vector3f vector3f = new Vector3f(skyDarken, skyDarken, 1.0f);
            vector3f.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f vector3f1 = new Vector3f();
            float f9 = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelX) * skyLight;
            float f10 = f9 * (f9 * f9 * 0.6f + 0.4f);
            vector3f1.m_122245_(f10, f10, f10);
            boolean flag = level.m_104583_().m_108884_();
            if (flag) {
                vector3f1.m_122255_(new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                vector3f1.m_122242_(0.0f, 1.0f);
            } else {
                Vector3f vector3f2 = vector3f.m_122281_();
                vector3f2.m_122261_(blockLight);
                vector3f1.m_122253_(vector3f2);
                vector3f1.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (Minecraft.m_91087_().f_91063_.m_109131_(partialTicks) > 0.0f) {
                    float darken = Minecraft.m_91087_().f_91063_.m_109131_(partialTicks);
                    Vector3f vector3f3 = vector3f1.m_122281_();
                    vector3f3.m_122263_(0.7f, 0.6f, 0.6f);
                    vector3f1.m_122255_(vector3f3, darken);
                }
            }
            float[] finalColors = new float[]{vector3f1.m_122239_(), vector3f1.m_122260_(), vector3f1.m_122269_()};
            colors.set(finalColors);
        }
    }

    @Nullable
    public float[] m_7518_(float timeOfDay, float partialTicks) {
        if (((Boolean)AetherConfig.CLIENT.green_sunset.get()).booleanValue()) {
            float f1 = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.5f + 0.0f;
                this.sunriseCol[1] = f3 * f3 * 0.3f + 0.3f;
                this.sunriseCol[2] = f3 * f3 * 0.5f + 0.3f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }
        float f1 = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + 0.65f;
            this.sunriseCol[1] = f3 * f3 * 0.7f + 0.25f;
            this.sunriseCol[2] = f3 * f3 * 0.0f + 0.4f;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public Vec3 m_5927_(Vec3 color, float brightness) {
        return this.OVERWORLD.m_5927_(color, brightness);
    }

    public boolean m_5781_(int x, int z) {
        return this.OVERWORLD.m_5781_(x, z);
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        float cloudHeight = level.m_104583_().m_108871_();
        if (!Float.isNaN(cloudHeight)) {
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69458_((boolean)true);
            double d1 = ((float)ticks + partialTick) * 0.03f;
            double d2 = (camX + d1) / 12.0;
            double d3 = cloudHeight - (float)camY + 0.33f;
            double d4 = camZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
            Vec3 vec3 = this.getCloudColor(level, partialTick);
            int i = Mth.m_14107_((double)d2);
            int j = Mth.m_14107_((double)(d3 / 4.0));
            int k = Mth.m_14107_((double)d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || Minecraft.m_91087_().f_91066_.m_92174_() != ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() || this.prevCloudColor.m_82557_(vec3) > 2.0E-4) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vec3;
                ((LevelRendererAccessor)levelRenderer).aether$setPrevCloudsType(Minecraft.m_91087_().f_91066_.m_92174_());
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(true);
            }
            if (((LevelRendererAccessor)levelRenderer).aether$isGenerateClouds()) {
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(false);
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null) {
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().close();
                }
                ((LevelRendererAccessor)levelRenderer).aether$setCloudBuffer(new VertexBuffer());
                BufferBuilder.RenderedBuffer renderedBuffer = ((LevelRendererAccessor)levelRenderer).callBuildClouds(bufferbuilder, d2, d3, d4, vec3);
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_85921_();
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_231221_(renderedBuffer);
                VertexBuffer.m_85931_();
            }
            RenderSystem.m_157427_(GameRenderer::m_172838_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CLOUDS_LOCATION);
            FogRenderer.m_109036_();
            poseStack.m_85836_();
            poseStack.m_85841_(12.0f, 1.0f, 12.0f);
            poseStack.m_85837_((double)(-f3), (double)f4, (double)(-f5));
            if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null && RenderSystem.m_157196_() != null) {
                int l;
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_85921_();
                for (int i1 = l = ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                    if (i1 == 0) {
                        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderInstance = RenderSystem.m_157196_();
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, shaderInstance);
                }
                VertexBuffer.m_85931_();
            }
            poseStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
        }
        return true;
    }

    public Vec3 getCloudColor(ClientLevel level, float partialTick) {
        float f = level.m_46942_(partialTick);
        float f1 = Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = level.m_46722_(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.725f;
            float f7 = 1.0f - f5 * 0.8f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = level.m_46661_(partialTick);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.5f;
            float f8 = 1.0f - f9 * 0.7f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (RenderSystem.m_157196_() != null) {
            LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
            Vec3 vec3 = this.getSkyColor(level, camera.m_90583_(), partialTick);
            float f = (float)vec3.m_7096_();
            float f1 = (float)vec3.m_7098_();
            float f2 = (float)vec3.m_7094_();
            FogRenderer.m_109036_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderInstance = RenderSystem.m_157196_();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().m_85921_();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, shaderInstance);
            VertexBuffer.m_85931_();
            RenderSystem.m_69478_();
            float[] sunRiseRGBA = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
            if (sunRiseRGBA != null) {
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                float f3 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f3));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                float f4 = sunRiseRGBA[0];
                float f5 = sunRiseRGBA[1];
                float f6 = sunRiseRGBA[2];
                Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
                bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, sunRiseRGBA[3]).m_5752_();
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = Mth.m_14031_((float)f7);
                    float f9 = Mth.m_14089_((float)f7);
                    bufferBuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunRiseRGBA[3]).m_85950_(sunRiseRGBA[0], sunRiseRGBA[1], sunRiseRGBA[2], 0.0f).m_5752_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                poseStack.m_85849_();
            }
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            this.drawCelestialBodies(partialTick, poseStack, level, bufferBuilder);
            float f10 = level.m_104811_(partialTick);
            if (f10 > 0.0f && GameRenderer.m_172808_() != null) {
                RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
                FogRenderer.m_109017_();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().m_85921_();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172808_());
                VertexBuffer.m_85931_();
                setupFog.run();
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
            RenderSystem.m_69458_((boolean)true);
        }
        return true;
    }

    public Vec3 getSkyColor(ClientLevel level, Vec3 pos, float partialTick) {
        float f9;
        float f = level.m_46942_(partialTick);
        Vec3 vec3 = pos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        BiomeManager biomeManager = level.m_7062_();
        Vec3 vec31 = CubicSampler.m_130038_((Vec3)vec3, (x, y, z) -> Vec3.m_82501_((int)((Biome)biomeManager.m_204210_(x, y, z).m_203334_()).m_47463_()));
        float f1 = Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.m_7096_() * f1;
        float f3 = (float)vec31.m_7098_() * f1;
        float f4 = (float)vec31.m_7094_() * f1;
        float f5 = level.m_46722_(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.61f;
            float f7 = 1.0f - f5 * 0.2f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = level.m_46661_(partialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.48f;
            float f8 = 1.0f - f9 * 0.21f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231935_().m_231551_()).booleanValue() && level.m_104819_() > 0) {
            float f11 = (float)level.m_104819_() - partialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + f11;
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    private void drawCelestialBodies(float partialTick, PoseStack poseStack, ClientLevel level, BufferBuilder bufferBuilder) {
        float moonOpacity;
        float sunOpacity;
        long dayTime = level.m_46468_() % 72000L;
        if (dayTime > 71400L) {
            sunOpacity = Math.min((float)(dayTime -= 71400L) * 0.00167f, 1.0f);
            moonOpacity = Math.max(1.0f - (float)dayTime * 0.00167f, 0.0f);
        } else if (dayTime > 38400L) {
            sunOpacity = Math.max(1.0f - (float)(dayTime -= 38400L) * 0.00167f, 0.0f);
            moonOpacity = Math.min((float)dayTime * 0.00167f, 1.0f);
        } else {
            sunOpacity = 1.0f;
            moonOpacity = 0.0f;
        }
        sunOpacity -= level.m_46722_(partialTick);
        moonOpacity -= level.m_46722_(partialTick);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTick) * 360.0f));
        Matrix4f matrix4f1 = poseStack.m_85850_().m_85861_();
        float celestialOffset = 30.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)sunOpacity);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_LOCATION);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f1, -celestialOffset, 100.0f, -celestialOffset).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, celestialOffset, 100.0f, -celestialOffset).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, celestialOffset, 100.0f, celestialOffset).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, -celestialOffset, 100.0f, celestialOffset).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)moonOpacity);
        celestialOffset = 20.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_LOCATION);
        int moonPhase = level.m_46941_();
        int textureX = moonPhase % 4;
        int textureY = moonPhase / 4 % 2;
        float uLeft = (float)textureX / 4.0f;
        float vDown = (float)textureY / 2.0f;
        float uRight = (float)(textureX + 1) / 4.0f;
        float vUp = (float)(textureY + 1) / 2.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f1, -celestialOffset, -100.0f, celestialOffset).m_7421_(uRight, vUp).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, celestialOffset, -100.0f, celestialOffset).m_7421_(uLeft, vUp).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, celestialOffset, -100.0f, -celestialOffset).m_7421_(uLeft, vDown).m_5752_();
        bufferBuilder.m_85982_(matrix4f1, -celestialOffset, -100.0f, -celestialOffset).m_7421_(uRight, vDown).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

