/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.component.menu.AetherMenuButton;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.AetherModUpdateIndicator;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.internal.BrandingControl;

public class AetherTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation AETHER_LOGO = new ResourceLocation("aether", "textures/gui/title/aether.png");
    public static final Music MENU = new Music((SoundEvent)AetherSoundEvents.MUSIC_MENU.get(), 20, 600, true);
    private final PanoramaRenderer panorama = new PanoramaRenderer(new CubeMap(new ResourceLocation("aether", "textures/gui/title/panorama/panorama")));
    private AetherModUpdateIndicator modUpdateNotification;
    private boolean alignedLeft;
    private int rows;

    public AetherTitleScreen() {
        ((TitleScreenAccessor)((Object)this)).aether$setFading(true);
    }

    public AetherTitleScreen(boolean alignedLeft) {
        this();
        this.alignedLeft = alignedLeft;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupButtons();
        this.modUpdateNotification = new AetherModUpdateIndicator(this);
        this.modUpdateNotification.m_7856_();
    }

    public void setupButtons() {
        int buttonRows = 0;
        int lastY = 0;
        for (Widget renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)renderable;
            if (TitleScreenBehavior.isImageButton(abstractWidget.m_6035_())) {
                abstractWidget.f_93624_ = false;
            }
            if (!(abstractWidget instanceof AetherMenuButton)) continue;
            AetherMenuButton aetherMenuButton = (AetherMenuButton)abstractWidget;
            if (!this.isAlignedLeft() && lastY < aetherMenuButton.originalY) {
                lastY = aetherMenuButton.originalY;
                ++buttonRows;
            }
            aetherMenuButton.buttonCountOffset = ++buttonRows;
        }
        this.rows = this.alignedLeft ? buttonRows : buttonRows - 1;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)((Object)this);
        float fadeAmount = TitleScreenBehavior.super.handleFading(poseStack, this, titleScreenAccessor, this.panorama, PANORAMA_OVERLAY, partialTicks);
        float scale = AetherTitleScreen.getScale(this, this.getMinecraft());
        this.setupLogo(poseStack, fadeAmount, scale);
        int roundedFadeAmount = Mth.m_14167_((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (PoseStack)poseStack, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null) {
                float splashX = this.alignedLeft ? 400.0f / scale : (float)this.f_96543_ / 2.0f + 175.0f / scale;
                float splashY = this.alignedLeft ? 100.0f / scale : (float)((int)(20.0f + 76.0f / scale));
                poseStack.m_85836_();
                poseStack.m_85837_((double)splashX, (double)splashY, 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
                float textSize = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                String splash = titleScreenAccessor.aether$getSplash();
                textSize = textSize * (200.0f / scale) / ((float)this.f_96547_.m_92895_(splash) + 64.0f / scale);
                poseStack.m_85841_(textSize, textSize, textSize);
                GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)splash, (int)0, (int)((int)(-16.0f / scale)), (int)(0xFFFF00 | roundedFadeAmount));
                poseStack.m_85849_();
            }
            if (this.alignedLeft) {
                TitleScreenBehavior.super.renderRightBranding(poseStack, this, this.f_96547_, roundedFadeAmount);
            } else {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
                    int n = brandingLine;
                    Objects.requireNonNull(this.f_96547_);
                    AetherTitleScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)branding, (int)2, (int)(this.f_96544_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | roundedFadeAmount));
                });
                BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
                    int n = this.f_96543_ - this.f_96547_.m_92895_(branding);
                    int n2 = brandingLine + 1;
                    Objects.requireNonNull(this.f_96547_);
                    AetherTitleScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)branding, (int)n, (int)(this.f_96544_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | roundedFadeAmount));
                });
            }
        }
        int xOffset = TitleScreenBehavior.super.handleButtonVisibility(this, fadeAmount);
        for (Widget renderable : this.f_169369_) {
            renderable.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (renderable instanceof AetherMenuButton) {
                AetherMenuButton aetherButton = (AetherMenuButton)renderable;
                if (aetherButton.m_5953_(mouseX, mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 4;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        TitleScreenBehavior.super.handleImageButtons(this, xOffset);
        if (fadeAmount >= 1.0f) {
            this.modUpdateNotification.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    private void setupLogo(PoseStack poseStack, float transparency, float scale) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)AETHER_LOGO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
        int width = (int)(350.0f / scale);
        int height = (int)(76.0f / scale);
        int logoX = this.alignedLeft ? (int)(10.0f + 18.0f / scale) : (int)((float)(this.f_96543_ / 2) - 175.0f / scale);
        int logoY = this.alignedLeft ? (int)(15.0f + 10.0f / scale) : (int)(25.0f + 10.0f / scale);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)logoX, (int)logoY, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getScale(AetherTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        return AetherTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(AetherTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = AetherMenuButton.totalHeightRange(screen.rows, scale)) > screen.f_96544_ && scale != 1.0f) {
            return AetherTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((button = (Button)renderable).m_6035_())) {
            AetherMenuButton aetherButton = new AetherMenuButton(this, button);
            return (T)super.m_142416_((GuiEventListener)aetherButton);
        }
        return (T)super.m_142416_(renderable);
    }

    public boolean isAlignedLeft() {
        return this.alignedLeft;
    }
}

