/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.Builder;
import com.aetherteam.aether.client.gui.component.inventory.LorePageButton;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LoreBookScreen
extends AbstractContainerScreen<LoreBookMenu> {
    private static final ResourceLocation TEXTURE_LORE_BACKING = new ResourceLocation("aether", "textures/gui/menu/lore_backing.png");
    private static final ResourceLocation TEXTURE_LORE_BOOK = new ResourceLocation("aether", "textures/gui/menu/lore_book.png");
    private final Map<Integer, List<FormattedCharSequence>> pages = new HashMap<Integer, List<FormattedCharSequence>>();
    private LorePageButton previousButton;
    private LorePageButton nextButton;
    private int currentPageNumber;
    private ItemStack lastStack;

    public LoreBookScreen(LoreBookMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 199;
    }

    protected void m_7856_() {
        super.m_7856_();
        int xPos = (this.f_96543_ - this.getXSize()) / 2;
        int yPos = (this.f_96544_ - this.getYSize()) / 2;
        this.previousButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(new Builder((Component)Component.m_237113_((String)"<"), button -> {
            if (this.currentPageNumber > 0) {
                --this.currentPageNumber;
            }
        }).bounds(xPos + 14, yPos + 169, 20, 20)));
        this.nextButton = (LorePageButton)this.m_142416_((GuiEventListener)new LorePageButton(new Builder((Component)Component.m_237113_((String)">"), button -> {
            if (this.currentPageNumber < this.pages.size() - 1) {
                ++this.currentPageNumber;
            }
        }).bounds(xPos + 221, yPos + 169, 20, 20)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        String entryKey;
        MutableComponent previous = Component.m_237115_((String)"gui.aether.book_of_lore.previous");
        MutableComponent next = Component.m_237115_((String)"gui.aether.book_of_lore.next");
        this.drawNormalBookText(poseStack, this.f_96547_, (Component)previous, 13, 158);
        this.drawNormalBookText(poseStack, this.f_96547_, (Component)next, 221, 158);
        MutableComponent book = Component.m_237115_((String)"gui.aether.book_of_lore.book");
        MutableComponent ofLore = Component.m_237115_((String)"gui.aether.book_of_lore.of_lore");
        this.drawCenteredBookText(poseStack, this.f_96547_, (Component)book, 75, 20);
        this.drawCenteredBookText(poseStack, this.f_96547_, (Component)ofLore, 75, 30);
        MutableComponent item = Component.m_237115_((String)"gui.aether.book_of_lore.item");
        this.drawRightBookText(poseStack, this.f_96547_, (Component)item, 78, 67);
        ItemStack itemStack = ((Slot)((LoreBookMenu)this.m_6262_()).f_38839_.get(0)).m_7993_();
        if (!itemStack.m_41619_() && I18n.m_118936_((String)(entryKey = ((LoreBookMenu)this.m_6262_()).getLoreEntryKey(itemStack)))) {
            MutableComponent entry = Component.m_237115_((String)entryKey);
            this.createPages((Component)entry);
            if (this.currentPageNumber == 0) {
                MutableComponent title = itemStack.m_41786_().m_6879_();
                this.createText(poseStack, this.f_96547_.m_92923_((FormattedText)title, 98), 136, 10);
                this.createText(poseStack, this.pages.get(0), 136, 32);
            } else {
                this.createText(poseStack, this.pages.get(this.currentPageNumber), 136, 10);
            }
        }
        if (itemStack.m_41619_() || !itemStack.m_150930_(this.lastStack.m_41720_())) {
            this.pages.clear();
            this.currentPageNumber = 0;
        }
        this.previousButton.f_93623_ = this.currentPageNumber > 0;
        this.nextButton.f_93623_ = this.currentPageNumber < this.pages.size() - 1;
        this.lastStack = itemStack;
    }

    private void createPages(Component loreEntry) {
        ArrayList formattedText = new ArrayList(this.f_96547_.m_92923_((FormattedText)loreEntry, 98));
        if (formattedText.size() < 6) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.pages.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 6);
            this.pages.put(0, firstPage);
            List remainingPages = formattedText.subList(6, formattedText.size());
            List list = Lists.partition(remainingPages, (int)8);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.pages.put(i, (List)list.get(i - 1));
            }
        }
    }

    private void createText(PoseStack poseStack, List<FormattedCharSequence> reorderingProcessors, int x, int y) {
        int length = 0;
        for (FormattedCharSequence line : reorderingProcessors) {
            this.drawBookText(poseStack, this.f_96547_, line, x, y + length * 10);
            ++length;
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (this.f_96543_ - this.getXSize()) / 2;
        int yPos = (this.f_96544_ - this.getYSize()) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LORE_BACKING);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)xPos, (int)(yPos - 4), (float)0.0f, (float)0.0f, (int)this.getXSize(), (int)(this.getYSize() + 56), (int)256, (int)256);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LORE_BOOK);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(xPos + 12), (int)(yPos + 2), (float)0.0f, (float)0.0f, (int)this.getXSize(), (int)(this.getYSize() + 56), (int)256, (int)256);
    }

    private void drawNormalBookText(PoseStack poseStack, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(poseStack, fontRenderer, sequence, x, y);
    }

    private void drawRightBookText(PoseStack poseStack, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(poseStack, fontRenderer, sequence, x - fontRenderer.m_92724_(sequence), y);
    }

    private void drawCenteredBookText(PoseStack poseStack, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.m_7532_();
        this.drawBookText(poseStack, fontRenderer, sequence, x - fontRenderer.m_92724_(sequence) / 2, y);
    }

    private void drawBookText(PoseStack poseStack, Font fontRenderer, FormattedCharSequence sequence, int x, int y) {
        fontRenderer.m_92877_(poseStack, sequence, (float)x, (float)y, 0x404040);
    }
}

