/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.utils;

import io.github.linyimin0812.spring.startup.constant.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ShellUtil {
    public static Result execute(String[] cmdArray) {
        return ShellUtil.execute(cmdArray, false);
    }

    public static Result execute(String[] cmdArray, boolean print) {
        Result result;
        Process process = Runtime.getRuntime().exec(cmdArray);
        int code = process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(code == 0 ? process.getInputStream() : process.getErrorStream()));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
                if (!print) continue;
                Constants.OUT.println(line);
            }
            String content = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
            result = new Result(code, content);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return new Result(-1, e.getMessage());
            }
        }
        reader.close();
        return result;
    }

    public static class Result {
        public int code;
        public String content;

        public Result(int code, String content) {
            this.code = code;
            this.content = content;
        }

        public String toString() {
            return "Result{code=" + this.code + ", content='" + this.content + '\'' + '}';
        }
    }
}

