/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.utils;

import io.github.linyimin0812.spring.startup.constant.Constants;
import io.github.linyimin0812.spring.startup.utils.OSUtil;
import io.github.linyimin0812.spring.startup.utils.ShellUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ModuleUtil {
    public static List<Path> getModulePaths() {
        return ModuleUtil.getModulePaths(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public static List<Path> getModulePaths(Path home) {
        final ArrayList<Path> moduleHomes = new ArrayList<Path>();
        try {
            Files.walkFileTree(home, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    if (!path.toFile().isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (path.resolve("pom.xml").toFile().exists() || path.resolve("build.gradle").toFile().exists()) {
                        moduleHomes.add(path);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Constants.OUT.printf("Acquire module home from %s failed, error message: %s\n", home, e.getMessage());
            return moduleHomes;
        }
        return moduleHomes;
    }

    public static boolean compile(Path home) {
        if (ModuleUtil.isMaven(home)) {
            return ModuleUtil.buildWithMaven(home);
        }
        if (ModuleUtil.isGradle(home)) {
            return ModuleUtil.buildWithGradle(home);
        }
        Constants.OUT.println("[ERROR] compile error. only support for maven and gradle");
        return false;
    }

    public static boolean isMaven(Path home) {
        return ModuleUtil.hasFile(home, "pom.xml");
    }

    public static boolean isGradle(Path home) {
        return ModuleUtil.hasFile(home, "build.gradle");
    }

    public static boolean hasMvnW(Path home) {
        if (OSUtil.isWindows()) {
            return ModuleUtil.hasFile(home, "mvnw.cmd");
        }
        if (OSUtil.isUnix()) {
            return ModuleUtil.hasFile(home, "mvnw");
        }
        return false;
    }

    public static boolean hasGradleW(Path home) {
        if (OSUtil.isWindows()) {
            return ModuleUtil.hasFile(home, "gradlew.bat");
        }
        if (OSUtil.isUnix()) {
            return ModuleUtil.hasFile(home, "gradlew");
        }
        return false;
    }

    public static boolean buildWithMaven(Path home) {
        String[] commands = new String[]{};
        if (ModuleUtil.hasMvnW(home)) {
            if (OSUtil.isUnix()) {
                commands = new String[]{"./mvnw", "compile"};
            }
            if (OSUtil.isWindows()) {
                commands = new String[]{"./mvnw.cmd", "compile"};
            }
        } else {
            commands = new String[]{"mvn", "compile"};
        }
        ShellUtil.Result result = ShellUtil.execute(commands, true);
        return result.code == 0;
    }

    public static boolean buildWithGradle(Path home) {
        String[] commands = new String[]{};
        if (ModuleUtil.hasGradleW(home)) {
            if (OSUtil.isUnix()) {
                commands = new String[]{"./gradlew", "build", "-x", "test"};
            }
            if (OSUtil.isWindows()) {
                commands = new String[]{"./gradlew.bat", "build", "-x", "test"};
            }
        } else {
            commands = new String[]{"gradle", "build", "-x", "test"};
        }
        ShellUtil.Result result = ShellUtil.execute(commands, true);
        return result.code == 0;
    }

    private static boolean hasFile(Path home, final String name) {
        if (Files.notExists(home, LinkOption.NOFOLLOW_LINKS) || !Files.isDirectory(home, LinkOption.NOFOLLOW_LINKS)) {
            return false;
        }
        final AtomicReference<Boolean> has = new AtomicReference<Boolean>(false);
        try {
            Files.walkFileTree(home, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    if (!path.toFile().isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (path.resolve(name).toFile().exists()) {
                        has.set(true);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return has.get();
    }
}

