/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.recompile;

import io.github.linyimin0812.spring.startup.recompile.ModifiedFileProcessor;
import io.github.linyimin0812.spring.startup.utils.ModuleUtil;
import io.github.linyimin0812.spring.startup.utils.StringUtil;
import io.methvin.watcher.DirectoryWatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class ModifiedFileWatcher {
    private final DirectoryWatcher watcher;
    public boolean running = false;

    public ModifiedFileWatcher(ModifiedFileProcessor processor) throws IOException {
        this(System.getProperty("user.dir"), processor);
    }

    public ModifiedFileWatcher(String dir, ModifiedFileProcessor processor) throws IOException {
        Path path = Paths.get(dir, new String[0]);
        List<Path> moduleHomes = ModuleUtil.getModulePaths(path);
        List<Path> moduleSourceDirs = moduleHomes.stream().map(moduleHome -> moduleHome.resolve("src/main/java")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
        this.watcher = DirectoryWatcher.builder().paths(moduleSourceDirs).listener(processor::onEvent).build();
        int longest = moduleHomes.stream().map(Path::toString).map(String::length).max(Integer::compareTo).orElse(0) + 32;
        for (Path moduleHome2 : moduleHomes) {
            System.out.format("[INFO] %s WATCHING\n", StringUtil.rightPad(moduleHome2.toString() + " ", longest, "."));
        }
        new Thread(this.watcher::watch).start();
        this.running = true;
    }

    public void close() throws IOException {
        this.running = false;
        this.watcher.close();
    }
}

