/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.recompile;

import io.github.linyimin0812.spring.startup.cli.CliMain;
import io.github.linyimin0812.spring.startup.constant.Constants;
import io.github.linyimin0812.spring.startup.jdwp.JDWPClient;
import io.github.linyimin0812.spring.startup.jdwp.command.AllClassesCommand;
import io.github.linyimin0812.spring.startup.jdwp.command.AllClassesReplyPackage;
import io.github.linyimin0812.spring.startup.jdwp.command.RedefineClassesCommand;
import io.github.linyimin0812.spring.startup.jdwp.command.RedefineClassesReplyPackage;
import io.github.linyimin0812.spring.startup.utils.ModuleUtil;
import io.methvin.watcher.DirectoryChangeEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModifiedFileProcessor {
    private final Map<String, DirectoryChangeEvent> FILE_WATCH_EVENTS = new ConcurrentHashMap<String, DirectoryChangeEvent>();
    private final Map<String, Path> RECOMIPLED_FILE_MAP = new ConcurrentHashMap<String, Path>();

    public void onEvent(DirectoryChangeEvent event) {
        String path = event.path().toString();
        if (!this.FILE_WATCH_EVENTS.containsKey(path)) {
            Constants.OUT.printf("\n[INFO] - [%s] %s\n", event.eventType().name(), path);
            Constants.OUT.printf(CliMain.prompt(), new Object[0]);
        }
        this.FILE_WATCH_EVENTS.put(path, event);
    }

    public void process(JDWPClient client) throws IOException {
        if (!this.check()) {
            return;
        }
        Map<String, Long> loadedClass = this.acquireLoadedClass(client);
        RedefineClassesCommand redefineClassesCommand = this.buildRedefineClassesCommand(loadedClass);
        RedefineClassesReplyPackage replyPackage = new RedefineClassesReplyPackage(client.execute(redefineClassesCommand.toBytes()));
        this.printHostSwapInfo(((RedefineClassesCommand.Data)redefineClassesCommand.getData()).getClasses(), replyPackage);
        this.FILE_WATCH_EVENTS.clear();
        this.RECOMIPLED_FILE_MAP.clear();
    }

    public boolean check() {
        if (this.FILE_WATCH_EVENTS.isEmpty()) {
            Constants.OUT.println("There are no file changes, don't need to hotswap.");
            return false;
        }
        boolean anyAdded = this.FILE_WATCH_EVENTS.values().stream().anyMatch(event -> event.eventType() == DirectoryChangeEvent.EventType.CREATE);
        if (anyAdded) {
            Constants.OUT.println("Hotswap does not support adding new files, please restart the application");
            return false;
        }
        return true;
    }

    private void printHostSwapInfo(int classes, RedefineClassesReplyPackage replyPackage) {
        if (!replyPackage.isSuccess()) {
            Constants.OUT.printf("Hotswap failed, error code: %s\n", replyPackage.getErrorCode());
            return;
        }
        Constants.OUT.printf("[INFO] hotswap success, reloaded classes: %s\n", classes);
        for (Map.Entry<String, Path> entry : this.RECOMIPLED_FILE_MAP.entrySet()) {
            Constants.OUT.printf("  class - %s\n", entry.getKey());
            Constants.OUT.printf("  |_ file - %s\n", entry.getValue());
        }
    }

    private Map<String, Long> acquireLoadedClass(JDWPClient client) throws IOException {
        AllClassesCommand allClassesCommand = new AllClassesCommand();
        AllClassesReplyPackage allClassesReplyPackage = new AllClassesReplyPackage(client.execute(allClassesCommand.toBytes()));
        HashMap<String, Long> cache = new HashMap<String, Long>();
        for (AllClassesReplyPackage.Data data : (List)allClassesReplyPackage.getData()) {
            if (data.getRefTypeTag() != 1 && data.getRefTypeTag() != 2) continue;
            String classQualifier = data.getSignature().substring(1, data.getSignature().length() - 1).replace(File.separator, ".");
            cache.put(classQualifier, data.getReferenceTypeId());
        }
        return cache;
    }

    private RedefineClassesCommand buildRedefineClassesCommand(Map<String, Long> loadedClass) throws IOException {
        this.RECOMIPLED_FILE_MAP.putAll(this.acquireRecompiledFileMap());
        ArrayList<RedefineClassesCommand.RedefineClass> redefineClasses = new ArrayList<RedefineClassesCommand.RedefineClass>();
        if (this.RECOMIPLED_FILE_MAP.isEmpty()) {
            return new RedefineClassesCommand(new RedefineClassesCommand.Data(redefineClasses));
        }
        for (Map.Entry<String, Path> entry : this.RECOMIPLED_FILE_MAP.entrySet()) {
            long referenceTypeId = loadedClass.getOrDefault(entry.getKey(), 0L);
            if (referenceTypeId == 0L) {
                Constants.OUT.println("[WARN] class not found: " + entry.getKey() + ", and will not be hotswap");
                continue;
            }
            byte[] classData = Files.readAllBytes(entry.getValue());
            RedefineClassesCommand.RedefineClass redefineClass = new RedefineClassesCommand.RedefineClass(referenceTypeId, classData);
            redefineClasses.add(redefineClass);
        }
        return new RedefineClassesCommand(new RedefineClassesCommand.Data(redefineClasses));
    }

    private Map<String, Path> acquireRecompiledFileMap() throws IOException {
        final HashMap<String, Path> recompileFileMap = new HashMap<String, Path>();
        for (String key : this.FILE_WATCH_EVENTS.keySet()) {
            String compilePath;
            Path changeFile = Paths.get(key, new String[0]);
            String fileDir = changeFile.getParent().toString();
            final String filePackage = this.getPackage(fileDir);
            Path home = Paths.get(System.getProperty("user.dir"), new String[0]);
            if (ModuleUtil.isMaven(home)) {
                compilePath = fileDir.replace("src/main/java", "target/classes");
            } else if (ModuleUtil.isGradle(home)) {
                compilePath = fileDir.replace("src/main/java", "build/classes");
            } else {
                Constants.OUT.printf("[WARN] file %s is not managed by maven or gradle, skip directly.\n", key);
                continue;
            }
            final String fileNameWithoutPrefix = changeFile.getFileName().toString().replace(".java", "");
            Files.walkFileTree(Paths.get(compilePath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String name = file.getFileName().toString();
                    if (name.equals(fileNameWithoutPrefix + ".class") || name.contains(fileNameWithoutPrefix + "$")) {
                        String qualifier = filePackage + name.replace(".class", "");
                        recompileFileMap.put(qualifier, file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return recompileFileMap;
    }

    private String getPackage(String fileDir) {
        int startIndex = fileDir.indexOf("src/main/java") + "src/main/java".length() + 1;
        if (startIndex >= fileDir.length()) {
            return "";
        }
        String filePackage = fileDir.substring(startIndex).replace(File.separator, ".");
        return filePackage.endsWith(".") ? filePackage : filePackage + ".";
    }
}

