/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.jdwp.command;

import io.github.linyimin0812.spring.startup.jdwp.command.CommandPackage;
import java.nio.ByteBuffer;
import java.util.List;

public class RedefineClassesCommand
extends CommandPackage<Data> {
    public RedefineClassesCommand(Data data) {
        super(11 + data.length(), CommandPackage.nextId(), (byte)0, (byte)1, (byte)18, data);
    }

    @Override
    byte[] dataBytes() {
        return ((Data)this.getData()).toBytes();
    }

    public static class Data {
        private final int classes;
        private final List<RedefineClass> redefineClasses;

        public Data(List<RedefineClass> redefineClasses) {
            this.classes = redefineClasses.size();
            this.redefineClasses = redefineClasses;
        }

        public int length() {
            return 4 + this.redefineClasses.stream().mapToInt(RedefineClass::length).sum();
        }

        public byte[] toBytes() {
            ByteBuffer buffer = ByteBuffer.allocate(this.length());
            buffer.putInt(this.classes);
            for (RedefineClass redefineClass : this.redefineClasses) {
                buffer.put(redefineClass.toBytes());
            }
            return buffer.array();
        }

        public int getClasses() {
            return this.classes;
        }
    }

    public static class RedefineClass {
        private final long referenceTypeId;
        private final int numOfBytes;
        private final byte[] classBytes;

        public RedefineClass(long referenceTypeId, byte[] classBytes) {
            this.referenceTypeId = referenceTypeId;
            this.numOfBytes = classBytes.length;
            this.classBytes = classBytes;
        }

        public int length() {
            return 12 + this.numOfBytes;
        }

        public byte[] toBytes() {
            ByteBuffer buffer = ByteBuffer.allocate(this.length());
            buffer.putLong(this.referenceTypeId);
            buffer.putInt(this.numOfBytes);
            buffer.put(this.classBytes);
            return buffer.array();
        }
    }
}

