/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.jdwp.command;

import io.github.linyimin0812.spring.startup.jdwp.command.CommandCache;
import io.github.linyimin0812.spring.startup.jdwp.command.Package;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CommandPackage<T>
extends Package<T> {
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final byte commandSet;
    private final byte command;

    public CommandPackage(int id, byte flag, byte commandSet, byte command) {
        this(11, id, flag, commandSet, command, null);
    }

    public CommandPackage(int length, int id, byte flag, byte commandSet, byte command, T data) {
        super(length, id, flag, data);
        this.commandSet = commandSet;
        this.command = command;
        CommandCache.cache(id, this);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getLength());
        buffer.putInt(this.getLength());
        buffer.putInt(this.getId());
        buffer.put(this.getFlag());
        buffer.put(this.commandSet);
        buffer.put(this.command);
        buffer.put(this.dataBytes());
        return buffer.array();
    }

    abstract byte[] dataBytes();

    public static int nextId() {
        return ID_GENERATOR.incrementAndGet();
    }

    public byte getCommandSet() {
        return this.commandSet;
    }

    public byte getCommand() {
        return this.command;
    }
}

