/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.jdwp.command;

import io.github.linyimin0812.spring.startup.jdwp.command.ReplyPackage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AllClassesReplyPackage
extends ReplyPackage<List<Data>> {
    public AllClassesReplyPackage(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    List<Data> parseData(ByteBuffer buffer) {
        int classes = buffer.getInt();
        ArrayList<Data> list = new ArrayList<Data>(classes);
        for (int i = 0; i < classes; ++i) {
            byte refTypeTag = buffer.get();
            long referenceTypeId = buffer.getLong();
            int stringLength = buffer.getInt();
            byte[] signatureBytes = new byte[stringLength];
            buffer.get(signatureBytes, 0, stringLength);
            String signature = new String(signatureBytes, StandardCharsets.UTF_8);
            int status = buffer.getInt();
            list.add(new Data(refTypeTag, referenceTypeId, signature, status));
        }
        return list;
    }

    public static class Data {
        private final byte refTypeTag;
        private final long referenceTypeId;
        private final String signature;
        private final int status;

        public Data(byte refTypeTag, long referenceTypeId, String signature, int status) {
            this.refTypeTag = refTypeTag;
            this.referenceTypeId = referenceTypeId;
            this.signature = signature;
            this.status = status;
        }

        public byte getRefTypeTag() {
            return this.refTypeTag;
        }

        public long getReferenceTypeId() {
            return this.referenceTypeId;
        }

        public String getSignature() {
            return this.signature;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

