/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.jdwp;

import io.github.linyimin0812.spring.startup.constant.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class JDWPClient {
    private final Socket socket;
    private final String host;
    private final Integer port;
    public static final int LENGTH_SIZE = 4;

    public JDWPClient(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.socket = new Socket(host, port);
    }

    public boolean start() throws IOException {
        boolean isConnected;
        String handshakeCommand = "JDWP-Handshake";
        InputStream in = this.socket.getInputStream();
        OutputStream out = this.socket.getOutputStream();
        out.write(handshakeCommand.getBytes(StandardCharsets.UTF_8));
        byte[] handshakeResponseBytes = new byte[14];
        int bytesRead = in.read(handshakeResponseBytes);
        boolean bl = isConnected = bytesRead == handshakeResponseBytes.length && handshakeCommand.equals(new String(handshakeResponseBytes, StandardCharsets.UTF_8));
        if (isConnected) {
            Constants.OUT.printf("[INFO] Connected to the target VM, address: '%s:%s', transport: 'socket'\n", this.host, this.port);
        }
        return isConnected;
    }

    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public synchronized ByteBuffer execute(byte[] command) throws IOException {
        int bytesRead;
        OutputStream out = this.socket.getOutputStream();
        InputStream in = this.socket.getInputStream();
        out.write(command);
        byte[] replyBytes = new byte[4];
        for (bytesRead = 0; bytesRead != 4; bytesRead += in.read(replyBytes, bytesRead, 4 - bytesRead)) {
        }
        int length = ByteBuffer.wrap(replyBytes).getInt();
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.putInt(length);
        while (bytesRead != length) {
            replyBytes = new byte[4096];
            int currentBytesRead = in.read(replyBytes);
            buffer.put(replyBytes, 0, currentBytesRead);
            bytesRead += currentBytesRead;
        }
        buffer.flip();
        return buffer;
    }
}

