/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.cli.command;

import io.github.linyimin0812.spring.startup.cli.command.CliCommands;
import io.github.linyimin0812.spring.startup.constant.Constants;
import io.github.linyimin0812.spring.startup.jdwp.JDWPClient;
import io.github.linyimin0812.spring.startup.utils.GitUtil;
import io.github.linyimin0812.spring.startup.utils.ModuleUtil;
import io.github.linyimin0812.spring.startup.utils.ShellUtil;
import io.github.linyimin0812.spring.startup.utils.StringUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import picocli.CommandLine;

@CommandLine.Command(name="reload", mixinStandardHelpOptions=true, description={"reload modified classes"}, version={"1.0"})
public class Reload
implements Runnable {
    @CommandLine.ParentCommand
    CliCommands parent;
    private boolean isMerge = false;

    @Override
    public void run() {
        if (!this.parent.getProcessor().check()) {
            return;
        }
        Constants.OUT.printf("[INFO] branch: %s, remote jvm host: %s, remote jvm port: %s\n", this.parent.getBranch(), this.parent.getHost(), this.parent.getPort());
        String originBranch = GitUtil.currentBranch();
        try {
            if (!this.merge(originBranch)) {
                Constants.OUT.println("[ERROR] merge branch error. try to resolve the problem and execute reload command again");
                return;
            }
            if (!this.compile()) {
                Constants.OUT.println("[ERROR] compile branch error. try to resolve the problem and execute reload command again");
                return;
            }
            this.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.rollback(originBranch);
        }
    }

    private boolean merge(String originBranch) {
        Constants.OUT.println("[INFO] start merge branch ...");
        if (!GitUtil.isGit()) {
            Constants.OUT.println("[WARN] project is not managed by git, skip the merge process, use the code directly");
            return true;
        }
        String deployedBranch = this.parent.getBranch();
        if (StringUtil.isEmpty(deployedBranch)) {
            Constants.OUT.println("[WARN] branch is empty, skip the merge process, use the code directly");
            return true;
        }
        if (deployedBranch.equals(originBranch)) {
            Constants.OUT.println("[INFO] configured branch is the same as the current branch, directly use the current branch.");
            return true;
        }
        ShellUtil.execute(new String[]{"git", "add", "."});
        ShellUtil.execute(new String[]{"git", "commit", "-m", "deployment: for reload"});
        ShellUtil.execute(new String[]{"git", "pull", deployedBranch});
        ShellUtil.execute(new String[]{"git", "checkout", deployedBranch});
        ShellUtil.Result result = ShellUtil.execute(new String[]{"git", "merge", originBranch});
        Constants.OUT.println(result.content);
        this.isMerge = result.code == 0;
        return this.isMerge;
    }

    private boolean compile() {
        Constants.OUT.println("[INFO] start compile ...");
        Path home = Paths.get(System.getProperty("user.dir"), new String[0]);
        return ModuleUtil.compile(home);
    }

    private void rollback(String originBranch) {
        Constants.OUT.println("[INFO] start rollback branch ...");
        ShellUtil.execute(new String[]{"git", "checkout", originBranch});
        if (this.isMerge) {
            ShellUtil.execute(new String[]{"git", "checkout", originBranch});
            ShellUtil.execute(new String[]{"git", "reset", "--mixed", "HEAD^"});
        }
        this.isMerge = false;
    }

    private void reload() throws IOException {
        Constants.OUT.println("[INFO] start reload ...");
        try (JDWPClient client = null;){
            String host = this.parent.getHost();
            Integer port = this.parent.getPort();
            client = new JDWPClient(host, port);
            client.start();
            this.parent.getProcessor().process(client);
        }
    }
}

