/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.cli.command;

import io.github.linyimin0812.spring.startup.cli.command.CliCommands;
import io.github.linyimin0812.spring.startup.constant.Constants;
import io.github.linyimin0812.spring.startup.utils.GitUtil;
import io.github.linyimin0812.spring.startup.utils.StringUtil;
import org.jline.reader.MaskingCallback;
import picocli.CommandLine;

@CommandLine.Command(name="config", description={"configuration setting, use 'config -h' for more information"}, version={"1.0"}, mixinStandardHelpOptions=true)
public class Config
implements Runnable {
    @CommandLine.ParentCommand
    CliCommands parent;

    @CommandLine.Command(version={"1.0"}, description={"config deployment branch, remote debug jvm host and port"}, mixinStandardHelpOptions=true)
    public void set() {
        this.setBranch();
        this.setHost();
        this.setPort();
        Constants.OUT.print("[INFO] configuration setting success. configuration - ");
        Constants.OUT.printf("branch: %s, host: %s, port: %s\n", this.parent.getBranch(), this.parent.getHost(), this.parent.getPort());
    }

    @CommandLine.Command(version={"1.0"}, description={"view config information"}, mixinStandardHelpOptions=true)
    public void view() {
        Constants.OUT.printf("[INFO] configuration - branch: %s, host: %s, port: %s", this.parent.getBranch(), this.parent.getHost(), this.parent.getPort());
    }

    @Override
    public void run() {
        Constants.OUT.println("configuration setting, use 'config -h' for more information");
    }

    private void setBranch() {
        String line = this.parent.getReader().readLine(this.currentBranchPrompt(), null, (MaskingCallback)null, null);
        if (StringUtil.isNotEmpty(line)) {
            this.parent.setBranch(line);
        }
    }

    private void setHost() {
        String line = this.parent.getReader().readLine("jvm host (12.0.0.1) : ", null, (MaskingCallback)null, null);
        if (StringUtil.isNotEmpty(line)) {
            this.parent.setHost(line);
        }
    }

    private void setPort() {
        String line = this.parent.getReader().readLine("jvm port (5005) : ", null, (MaskingCallback)null, null);
        if (StringUtil.isNotEmpty(line)) {
            this.parent.setPort(Integer.parseInt(line));
        }
    }

    private String currentBranchPrompt() {
        String prompt = "deployment branch";
        String currentBranch = GitUtil.currentBranch();
        if (StringUtil.isNotEmpty(currentBranch)) {
            return prompt + " (" + currentBranch + ") : ";
        }
        return prompt + " : ";
    }
}

