/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.spring.startup.cli;

import io.github.linyimin0812.spring.startup.cli.command.CliCommands;
import io.github.linyimin0812.spring.startup.constant.Constants;
import io.github.linyimin0812.spring.startup.utils.GitUtil;
import io.github.linyimin0812.spring.startup.utils.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import org.fusesource.jansi.AnsiConsole;
import org.jline.builtins.ConfigurationPath;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

public class CliMain {
    private static CliCommands commands;
    private static LineReader reader;
    private static SystemRegistry systemRegistry;
    private static final Parser parser;

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        try {
            CliMain.initCommands();
            if (args.length > 0 && "exec:exec@java-agent".equals(args[0])) {
                CliMain.forNativeTracingAgent();
                return;
            }
            CliMain.executeCommand();
        }
        catch (Throwable t) {
            Constants.OUT.println(t.getMessage());
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    private static void initCommands() throws IOException {
        Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path userConfigPath = Paths.get(System.getenv("PATH"), new String[0]);
        Builtins builtins = new Builtins(new HashSet<Builtins.Command>(Collections.singleton(Builtins.Command.HISTORY)), () -> path, new ConfigurationPath(path, userConfigPath), null);
        commands = new CliCommands();
        PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
        PicocliCommands picocliCommands = new PicocliCommands(new CommandLine(commands, factory));
        picocliCommands.name("spring-startup-cli");
        Terminal terminal = TerminalBuilder.builder().build();
        systemRegistry = new SystemRegistryImpl(parser, terminal, () -> path, null);
        systemRegistry.setCommandRegistries(builtins, picocliCommands);
        reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser(parser).variable("list-max", 50).build();
        builtins.setLineReader(reader);
        commands.setReader(reader);
        factory.setTerminal(terminal);
    }

    private static void executeCommand() throws IOException {
        while (true) {
            try {
                String line;
                do {
                    systemRegistry.cleanUp();
                    line = reader.readLine(CliMain.prompt(), null, (MaskingCallback)null, null);
                    systemRegistry.execute(line);
                } while (!"exit".equalsIgnoreCase(line));
            }
            catch (EndOfFileException | UserInterruptException e) {
                commands.close();
                return;
            }
            catch (Exception e) {
                systemRegistry.trace(e);
                continue;
            }
            break;
        }
    }

    public static String prompt() {
        String currentBranch = GitUtil.currentBranch();
        if (StringUtil.isEmpty(currentBranch)) {
            return "spring-startup-cli > ";
        }
        return "spring-startup-cli (" + currentBranch + ") > ";
    }

    private static void forNativeTracingAgent() {
        Path file = Paths.get(System.getProperty("user.dir"), "src/main/java", "forNativeTracingAgent.java");
        new Thread(() -> {
            try {
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                Thread.sleep(1000L);
            }
            catch (IOException | InterruptedException ignored) {
            }
            finally {
                try {
                    commands.close();
                    Files.deleteIfExists(file);
                }
                catch (IOException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }).start();
    }

    static {
        parser = new DefaultParser();
    }
}

