/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Gfx {
    public static byte[] resizeProportionally(ImageIcon icon, String contentType, int newWidth, int newHeight) throws IOException {
        double heightRatio;
        double widthRatio = newWidth != icon.getIconWidth() ? (double)newWidth / (double)icon.getIconWidth() : 1.0;
        double d = heightRatio = newHeight != icon.getIconHeight() ? (double)newHeight / (double)icon.getIconHeight() : 1.0;
        if (widthRatio < heightRatio) {
            newHeight = (int)((double)icon.getIconHeight() * widthRatio);
        } else {
            newWidth = (int)((double)icon.getIconWidth() * heightRatio);
        }
        int imageType = "image/png".equals(contentType) ? 2 : 1;
        BufferedImage bImg = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), imageType);
        Graphics2D g2d = bImg.createGraphics();
        g2d.drawImage(icon.getImage(), 0, 0, icon.getIconWidth(), icon.getIconHeight(), null);
        g2d.dispose();
        BufferedImage scaledImg = Gfx.getScaledInstance(bImg, newWidth, newHeight, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, false);
        String formatName = "";
        if ("image/png".equals(contentType)) {
            formatName = "png";
        } else if ("image/jpeg".equals(contentType) || "image/jpg".equals(contentType)) {
            formatName = "jpeg";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ImageIO.write((RenderedImage)scaledImg, formatName, baos);
        return baos.toByteArray();
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h2;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h2 = img.getHeight();
        } else {
            w = targetWidth;
            h2 = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h2 > targetHeight && (h2 /= 2) < targetHeight) {
                h2 = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h2, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h2, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h2 != targetHeight);
        return ret;
    }
}

