/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.comparator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Comparator;

public class ComparatorFactory {
    private ComparatorFactory() {
    }

    public static Comparator<Constructor> createConstructorComparator() {
        return new ConstructorComparator(new ParametersComparator());
    }

    public static Comparator<Method> createMethodComparator() {
        return new MethodComparator(new ParametersComparator());
    }

    private static class ParametersComparator
    implements Comparator<Class[]> {
        private ParametersComparator() {
        }

        @Override
        public int compare(Class[] params1, Class[] params2) {
            int size = params1.length;
            for (int i = 0; i < size; ++i) {
                Class type1 = params1[i];
                Class type2 = params2[i];
                if (type1.equals(type2)) continue;
                if (type1.isAssignableFrom(type2)) {
                    if (!type1.isArray() && type2.isArray()) {
                        return -1;
                    }
                    return 1;
                }
                if (type1.isArray() && !type2.isArray()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    public static class MethodComparator
    implements Comparator<Method> {
        private final ParametersComparator parametersComparator;

        private MethodComparator(ParametersComparator parametersComparator) {
            this.parametersComparator = parametersComparator;
        }

        @Override
        public int compare(Method m1, Method m22) {
            Class[] typesMethod1 = m1.getParameterTypes();
            Class[] typesMethod2 = m22.getParameterTypes();
            return this.parametersComparator.compare(typesMethod1, typesMethod2);
        }
    }

    public static class ConstructorComparator
    implements Comparator<Constructor> {
        private final ParametersComparator parametersComparator;

        private ConstructorComparator(ParametersComparator parametersComparator) {
            this.parametersComparator = parametersComparator;
        }

        @Override
        public int compare(Constructor constructor1, Constructor constructor2) {
            Class[] parameters1 = constructor1.getParameterTypes();
            Class[] parameters2 = constructor2.getParameterTypes();
            return this.parametersComparator.compare(parameters1, parameters2);
        }
    }
}

