/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.reflect.Whitebox;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.ObjectFactory;

public class PowerMockTestCase {
    private Object annotationEnabler;
    private ClassLoader previousCl = null;

    public PowerMockTestCase() {
        try {
            Class<?> annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler");
            this.annotationEnabler = Whitebox.newInstance(annotationEnablerClass);
        }
        catch (ClassNotFoundException e) {
            this.annotationEnabler = null;
        }
    }

    @BeforeClass
    protected void beforePowerMockTestClass() throws Exception {
        MockRepository.clear();
        if (this.isLoadedByPowerMockClassloader()) {
            Thread thread = Thread.currentThread();
            this.previousCl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    @AfterClass
    protected void afterPowerMockTestClass() throws Exception {
        if (this.previousCl != null) {
            Thread.currentThread().setContextClassLoader(this.previousCl);
        }
    }

    @BeforeMethod
    protected void beforePowerMockTestMethod() throws Exception {
        this.injectMocks();
    }

    @AfterMethod
    protected void afterPowerMockTestMethod() throws Exception {
        try {
            this.clearMockFields();
        }
        finally {
            MockRepository.clear();
        }
    }

    @ObjectFactory
    public IObjectFactory create(ITestContext context) {
        try {
            Class<?> powerMockObjectFactory = Class.forName("org.powermock.modules.testng.PowerMockObjectFactory");
            return (IObjectFactory)powerMockObjectFactory.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Missing org.powermock.modules.testng.PowerMockObjectFactory in classpath.");
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error", e);
        }
    }

    private void clearMockFields() throws Exception {
        if (this.annotationEnabler != null) {
            Class[] mockAnnotations = (Class[])Whitebox.invokeMethod(this.annotationEnabler, "getMockAnnotations", new Object[0]);
            Set<Field> mockFields = Whitebox.getFieldsAnnotatedWith(this, mockAnnotations);
            for (Field field : mockFields) {
                field.set(this, null);
            }
        }
    }

    private void injectMocks() throws Exception {
        if (this.annotationEnabler != null) {
            Whitebox.invokeMethod(this.annotationEnabler, "beforeTestMethod", new Class[]{Object.class, Method.class, Object[].class}, new Object[]{this, null, null});
        }
    }

    private boolean isLoadedByPowerMockClassloader() {
        return this.getClass().getClassLoader() instanceof MockClassLoader;
    }
}

