/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.types.BytesRange;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.model.dlna.message.header.DLNAHeader;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTimeRange;
import org.fourthline.cling.support.model.dlna.types.TimeSeekRangeType;

public class TimeSeekRangeHeader
extends DLNAHeader<TimeSeekRangeType> {
    public TimeSeekRangeHeader() {
    }

    public TimeSeekRangeHeader(TimeSeekRangeType timeSeekRange) {
        this.setValue(timeSeekRange);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        String[] params;
        if (s2.length() != 0 && (params = s2.split(" ")).length > 0) {
            try {
                TimeSeekRangeType t2 = new TimeSeekRangeType(NormalPlayTimeRange.valueOf(params[0]));
                if (params.length > 1) {
                    t2.setBytesRange(BytesRange.valueOf(params[1]));
                }
                this.setValue(t2);
                return;
            }
            catch (InvalidValueException invalidValueException) {
                throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s2 + "; " + invalidValueException.getMessage());
            }
        }
        throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s2);
    }

    @Override
    public String getString() {
        TimeSeekRangeType t2 = (TimeSeekRangeType)this.getValue();
        String s2 = t2.getNormalPlayTimeRange().getString();
        if (t2.getBytesRange() != null) {
            s2 = s2 + " " + t2.getBytesRange().getString(true);
        }
        return s2;
    }
}

