/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model;

import java.util.ArrayList;
import org.fourthline.cling.model.ModelUtil;

public enum RecordQualityMode {
    EP("0:EP"),
    LP("1:LP"),
    SP("2:SP"),
    BASIC("0:BASIC"),
    MEDIUM("1:MEDIUM"),
    HIGH("2:HIGH"),
    NOT_IMPLEMENTED("NOT_IMPLEMENTED");

    private String protocolString;

    private RecordQualityMode(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static RecordQualityMode valueOrExceptionOf(String s2) throws IllegalArgumentException {
        for (RecordQualityMode recordQualityMode : RecordQualityMode.values()) {
            if (!recordQualityMode.protocolString.equals(s2)) continue;
            return recordQualityMode;
        }
        throw new IllegalArgumentException("Invalid record quality mode string: " + s2);
    }

    public static RecordQualityMode[] valueOfCommaSeparatedList(String s2) {
        String[] strings = ModelUtil.fromCommaSeparatedList(s2);
        if (strings == null) {
            return new RecordQualityMode[0];
        }
        ArrayList<RecordQualityMode> result = new ArrayList<RecordQualityMode>();
        for (String rqm : strings) {
            for (RecordQualityMode recordQualityMode : RecordQualityMode.values()) {
                if (!recordQualityMode.protocolString.equals(rqm)) continue;
                result.add(recordQualityMode);
            }
        }
        return result.toArray(new RecordQualityMode[result.size()]);
    }
}

