/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import org.fourthline.cling.model.types.AbstractDatatype;
import org.fourthline.cling.model.types.InvalidValueException;

public class ShortDatatype
extends AbstractDatatype<Short> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    @Override
    public Short valueOf(String s2) throws InvalidValueException {
        if (s2.equals("")) {
            return null;
        }
        try {
            Short value = Short.parseShort(s2.trim());
            if (!this.isValid(value)) {
                throw new InvalidValueException("Not a valid short: " + s2);
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s2, ex);
        }
    }
}

